package com.yizhi.application.report.courseStudyHour;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.course.application.feign.CourseStudyClient;
import com.yizhi.course.application.vo.StudyHourReportVO;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Ding
 * @className CourseStudyHourReportController
 * @description 学时统计报表
 * @date 2019/5/23
 **/
@Api(tags = "学时统计", description = "学时统计")
@RestController
@RequestMapping("/manage/report/studyHour")
public class CourseStudyHourReportController {

    private static final Logger LOGGER = LoggerFactory.getLogger(CourseStudyHourReportController.class);

    @Autowired
    private CourseStudyClient courseStudyClient;


    @ApiOperation(value = "学时统计列表", notes = "学时统计列表")
    @GetMapping("/list")
    public Response<StudyHourReportVO> getStudyHourList(

            @ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize,
            @ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
            @ApiParam(value = "用户关键字", required = false) @RequestParam(value = "userName", required = false) String userName,
            @ApiParam(value = "部门关键字", required = false) @RequestParam(value = "orgNameLike", required = false) String orgNameLike) {

        try {
            Map<String, Integer> pageMap = new HashMap<>();
            Page<StudyHourReportVO> page = courseStudyClient.getStudyHourList(userName, orgNameLike, pageNo, pageSize);
            Integer pageTotal = 0;
            if (null != page) {
                pageTotal = page.getTotal();
            }
            pageMap.put("pageNo", pageNo);
            pageMap.put("pageSize", pageSize);
            pageMap.put("pageTotal", pageTotal);
            return Response.ok(page, pageMap);
        } catch (Exception e) {
            LOGGER.error("获取数据过程中出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "学时统计下载", notes = "学时统计下载")
    @GetMapping("/listDownload")
    public Response<String> getStudyHourListDownload(
            @ApiParam(value = "用户关键字", required = false) @RequestParam(value = "userName", required = false) String userName,
            @ApiParam(value = "部门关键字", required = false) @RequestParam(value = "orgNameLike", required = false) String orgNameLike) {

        String serialNo = courseStudyClient.getStudyHourListDownload(userName, orgNameLike);
        return Response.ok("导出成功," + " " + "编号:" + serialNo);
    }

    @ApiOperation(value = "学时明细下载", notes = "学时明细下载")
    @GetMapping("/details/download")
    public Response<String> studyHourDetailsDownload(
            @ApiParam(value = "用户关键字", required = false) @RequestParam(value = "userName", required = false) String userName,
            @ApiParam(value = "部门关键字", required = false) @RequestParam(value = "orgNameLike", required = false) String orgNameLike) {

        String serialNo = courseStudyClient.studyHourDetailsDownload(userName, orgNameLike);
        return Response.ok("导出成功," + " " + "编号:" + serialNo);
    }
}
