package com.yizhi.application.research.controller.manage;

import com.yizhi.application.report.research.DownloadResearch;
import com.yizhi.application.report.research.DownloadResearchAnalyze;
import com.yizhi.application.report.research.DownloadResearchDetails;
import com.yizhi.application.report.research.vo.ReportResearchAnalyze;
import com.yizhi.application.report.research.vo.ReportResearchViewVo;
import com.yizhi.application.report.research.vo.ReportResearchVo;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.research.application.feign.*;
import com.yizhi.research.application.vo.domain.ResearchVo;
import com.yizhi.research.application.vo.domain.TrResearchQuestionVo;
import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.text.SimpleDateFormat;
import java.util.*;

@Api(tags = "导出-调研", description = "导出-调研")
@RestController
@RequestMapping("/manage/export/research2/")
public class ExportResearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResearchController.class);

    private SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    @Autowired
    private ResearchClient researchClient;
    @Autowired
    private ResearchReportClient researchReportClient;
    @Autowired
    private DownloadResearch downloadResearch;
    @Autowired
    private ResearchAnswerClient researchAnswerClient;
    @Autowired
    private DownloadResearchDetails downloadResearchDetails;
    @Autowired
    private DownloadResearchAnalyze downloadResearchAnalyze;
    @Autowired
    private ResearchQuestionClient researchQuestionClient;
    @Autowired
    private ResearchQuestionOptionClient researchQuestionOptionClient;
    @Autowired
    private AccountClient accountClient;

    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    @ApiOperation(value = "导出调研参与人员统计", notes = "导出调研参与人员统计")
    @GetMapping("/accounts")
    public Response<ReportResearchVo> reportResearchAccounts(
            @ApiParam(value = "调研id", required = true) @RequestParam(name = "researchId", required = true) Long researchId,
            @ApiParam(value = "部门关键字或者部门编码", required = false) @RequestParam(name = "orgNameorOrgCode", required = false) String orgNameorOrgCode,
            @ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountName", required = false) String accountName,
            @ApiParam(value = "参加状态", required = false) @RequestParam(name = "joinState", required = false) Integer joinState,
            @ApiParam(value = "开始时间", required = false) @RequestParam(name = "startDate", required = false) String startDate,
            @ApiParam(value = "结束时间", required = false) @RequestParam(name = "endDate", required = false) String endDate
    ) {
        try {
            if (startDate == "") {
                startDate = null;
            }
            if (endDate == "") {
                endDate = null;
            }
            if (orgNameorOrgCode != null) {
                orgNameorOrgCode = orgNameorOrgCode.replace(" ", "");
            }
            if (orgNameorOrgCode == "") {
                orgNameorOrgCode = null;
            }
            if (accountName != null) {
                accountName = accountName.replace(" ", "");
            }
            if (accountName == "") {
                accountName = null;
            }
            RequestContext context = ContextHolder.get();
            ResearchVo research = researchClient.viewOne(researchId);
            if (research == null) {
                return Response.fail("该调研不存在");
            }
            Long taskId = System.currentTimeMillis();
            String taskName = research.getName() + "用户清单" + "_" + taskId.toString();
            Map<String, Object> map = new LinkedHashMap<String, Object>();
            String serialNo = "USER-EXPORT-" + taskId.toString();
            map.put("taskId", taskId);
            map.put("serialNo", serialNo);
            map.put("startDate", startDate);
            map.put("endDate", endDate);
            map.put("orgNameorOrgCode", orgNameorOrgCode);
            map.put("accountName", accountName);
            map.put("joinState", joinState);
            map.put("context", context);
            map.put("research", research);
            map.put("taskName", taskName);
            downloadResearch.execute(map, true);
            return Response.ok("任务名称：" + taskName + ",任务序号:" + serialNo);
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }

    }

    @ApiOperation(value = "导出调研明细", notes = "导出调研明细")
    @GetMapping("/details")
    public Response<ReportResearchViewVo> reportResearchDetails(
            @ApiParam(value = "调研id", required = true) @RequestParam(name = "researchId", required = true) Long researchId,
            @ApiParam(value = "部门关键字或者部门编码", required = false) @RequestParam(name = "orgNameorOrgCode", required = false) String orgNameorOrgCode,
            @ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountName", required = false) String accountName,
            @ApiParam(value = "参加状态", required = false) @RequestParam(name = "joinState", required = false) Integer joinState,
            @ApiParam(value = "开始时间", required = false) @RequestParam(name = "startDate", required = false) String startDate,
            @ApiParam(value = "结束时间", required = false) @RequestParam(name = "endDate", required = false) String endDate
    ) {
        RequestContext context = ContextHolder.get();
        try {
            if (startDate == "") {
                startDate = null;
            }
            if (endDate == "") {
                endDate = null;
            }
            if (orgNameorOrgCode != null) {
                orgNameorOrgCode = orgNameorOrgCode.replace(" ", "");
            }
            if (orgNameorOrgCode == "") {
                orgNameorOrgCode = null;
            }
            if (accountName != null) {
                accountName = accountName.replace(" ", "");
            }
            if (accountName == "") {
                accountName = null;
            }
            ResearchVo research = researchClient.viewOne(researchId);
            if (research == null) {
                return Response.fail("该调研不存在");
            }
            Map<String, Object> map = new HashMap<String, Object>();
            Long taskId = System.currentTimeMillis();
            String serialNo = "RESEARCH-DETAILS-EXPORT-" + taskId.toString();
            String taskName = research.getName() + "调研明细" + "_" + taskId.toString();
            map.put("taskId", taskId);
            map.put("serialNo", serialNo);
            map.put("orgNameorOrgCode", orgNameorOrgCode);
            map.put("accountName", accountName);
            map.put("joinState", joinState);
            map.put("context", context);
            map.put("research", research);
            map.put("startDate", startDate);
            map.put("endDate", endDate);
            map.put("taskName", taskName);
            List<TrResearchQuestionVo> trResearchQuestions = researchQuestionClient.listAll(researchId);
            if (trResearchQuestions == null) {
                trResearchQuestions = new ArrayList<TrResearchQuestionVo>();
            }
            map.put("trResearchQuestion", trResearchQuestions);
            downloadResearchDetails.execute(map, true);
            return Response.ok("任务名称：" + taskName + ",任务序号:" + serialNo);
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "导出调研分析统计", notes = "导出调研分析统计")
    @GetMapping("/analyze")
    public Response<ReportResearchAnalyze> reportResearchanalyze(
            @ApiParam(value = "调研id", required = true) @RequestParam(name = "researchId", required = true) Long researchId,
            @ApiParam(value = "部门关键字或者部门编码", required = false) @RequestParam(name = "orgNameorOrgCode", required = false) String orgNameorOrgCode,
            @ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountName", required = false) String accountName,
            @ApiParam(value = "参加状态", required = false) @RequestParam(name = "joinState", required = false) Integer joinState,
            @ApiParam(value = "开始时间", required = false) @RequestParam(name = "startDate", required = false) String startDate,
            @ApiParam(value = "结束时间", required = false) @RequestParam(name = "endDate", required = false) String endDate
    ) {
        if (startDate == "") {
            startDate = null;
        }
        if (endDate == "") {
            endDate = null;
        }
        if (orgNameorOrgCode != null) {
            orgNameorOrgCode = orgNameorOrgCode.replace(" ", "");
        }
        if (orgNameorOrgCode == "") {
            orgNameorOrgCode = null;
        }
        if (accountName != null) {
            accountName = accountName.replace(" ", "");
        }
        if (accountName == "") {
            accountName = null;
        }
        Map<String, Object> map = new HashMap<String, Object>();
        RequestContext context = ContextHolder.get();
        ReportResearchAnalyze reportResearchAnalyze = new ReportResearchAnalyze();
        try {
            ResearchVo research = researchClient.getResearchView(researchId);
            if (research == null) {
                return Response.fail("该调研不存在");
            }
            Long taskId = System.currentTimeMillis();
            String serialNo = "RESEARCH-ANALYZE-EXPORT-" + taskId.toString();

            String taskName = research.getName() + "分析统计" + "_" + taskId.toString();
            map.put("taskId", taskId);
            map.put("serialNo", serialNo);
            map.put("taskName", taskName);
            map.put("orgNameorOrgCode", orgNameorOrgCode);
            map.put("accountName", accountName);
            map.put("joinState", joinState);
            map.put("research", research);
            map.put("context", context);
            map.put("startDate", startDate);
            map.put("endDate", endDate);
            map.put("reportResearchAnalyze", reportResearchAnalyze);
            downloadResearchAnalyze.execute(map, true);
            return Response.ok("任务名称：" + taskName + ",任务序号:" + serialNo);
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }
}
