package com.yizhi.application.customproject.contoller;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.assignment.application.feign.MinimbaClient;
import com.yizhi.assignment.application.vo.MinimbaStudyRecordVO;
import com.yizhi.assignment.application.vo.MinimbaUserDetailParamVO;
import com.yizhi.assignment.application.vo.MinimbaUserDetailVO;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.CommClient;
import com.yizhi.course.application.feign.CourseClient;
import com.yizhi.course.application.feign.CourseStudyClient;
import com.yizhi.course.application.vo.JaxinRankingVO;
import com.yizhi.course.application.vo.ProjectsDurationParamVO;
import com.yizhi.course.application.vo.ProjectsUserDetailsVO;
import com.yizhi.custom.api.feign.MyExperienceClient;
import com.yizhi.custom.api.feign.PurchaseProductClient;
import com.yizhi.custom.api.param.PurchaseProductsParam;
import com.yizhi.custom.api.vo.custom.*;
import com.yizhi.custom.api.vo.domain.ExperiencePoolVo;
import com.yizhi.custom.api.vo.domain.StudentExperiencePoolVo;
import com.yizhi.exam.application.feign.ExamClient;
import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.system.application.system.remote.ReportClient;
import com.yizhi.system.application.vo.AccountVO;
import com.yizhi.system.application.vo.ReportAccountRespVO;
import com.yizhi.system.application.vo.ReportRangeAccountReqVO;
import com.yizhi.training.application.feign.TpPlanFinishedApiClient;
import com.yizhi.training.application.feign.TpProjectClient;
import com.yizhi.training.application.vo.api.TpStudentProjectRecordVoVO;
import com.yizhi.training.application.vo.manage.TpPlanFinishedListVo;
import com.yizhi.training.application.vo.manage.TpPlanFinishedVo;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Api(tags = "我的经验池", description = "我的经验池")
@RestController
@RequestMapping("/api/my/")
public class ExperiencePoolStudentController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExperiencePoolStudentController.class);

    @Autowired
    private MyExperienceClient myExperienceClient;

    @Autowired
    private AccountClient accountClient;

    @Autowired
    private TpPlanFinishedApiClient tpPlanFinishedApiClient;

    @Autowired
    private TpProjectClient tpProjectClient;

    @Autowired
    private CommClient commClient;

    @Autowired
    private PurchaseProductClient purchaseProductClient;

    @Autowired
    private CourseClient courseClient;

    @Autowired
    private CourseStudyClient courseStudyClient;

    @Autowired
    private MinimbaClient minimbaClient;

    @Autowired
    private ExamClient examClient;

    @Autowired
    private ReportClient reportClient;

    @ApiOperation(value = "个人经验统计", notes = "个人经验统计", response = ExperiencePoolVo.class)
    @GetMapping("/experience")
    public Response<ExperiencePoolVo> getMyExperiencePool(
            @ApiParam(value = "经验池ID", required = true) @RequestParam(name = "poolId", required = true) Long poolId,
            @ApiParam(value = "排名方式：不传值全体，1批次，2组别", required = false) @RequestParam(name = "sort", required = false) String sort) {
        try {
            if (poolId == null) {
                return Response.fail();
            }
            if (StringUtils.isBlank(sort)) {
                sort = null;
            }

            MyExperienceLevelVo level = myExperienceClient.getMyExperiencePool(poolId, sort);
            if (level == null) {
                level = new MyExperienceLevelVo();
                level.setEventClassifys(null);
                level.setExperienceTotal(0);
                level.setLevelCode("");
                level.setLevelName("");
                level.setRanking("");
            }
            return Response.ok(level);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "经验排行榜", notes = "经验排行榜")
    @GetMapping("/experience/ranking")
    public Response<Object> getMyExperienceRankings(
            @ApiParam(value = "经验池ID", required = true) @RequestParam(name = "poolId", required = true) Long poolId,
            @ApiParam(value = "排名方式：1所有，2组别, 3批次", required = false) @RequestParam(name = "sort", required = false) String sort,
            @ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            @ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {
        try {
            if (poolId == null) {
                return Response.fail();
            }
            if (StringUtils.isBlank(sort)) {
                sort = null;
            }

            if (pageNo == null || pageNo <= 0) {
                pageNo = 1;
            }
            if (pageSize == null || pageSize <= 0) {
                pageSize = 10;
            }

            Map<String, Integer> pageMap = new HashMap<String, Integer>();
            pageMap.put("pageNo", pageNo);
            pageMap.put("pageSize", pageSize);

            Page<MyExperienceRankingVo> page = myExperienceClient.getMyExperienceRankings(poolId, sort, pageSize, pageNo);
            if (page == null) {
                pageMap.put("pageTotal", 0);
            } else {
                pageMap.put("pageTotal", page.getTotal());
            }

            //更新学员信息
            try {
                int size = page.getRecords().size();
                LOGGER.info("page ：" + size);
                if (page.getRecords() != null && size > 0) {
                    List<MyExperienceRankingVo> ls = page.getRecords();
                    List<Long> ids = new ArrayList<>(size);
                    for (MyExperienceRankingVo item : ls) {
                        ids.add(item.getAccountId());
                    }
                    LOGGER.info("call System：" + ids.toString());
                    List<AccountVO> acs = accountClient.idsGet(ids);

                    if (acs != null) {
                        LOGGER.info("call System ok：" + acs.size());
                        for (MyExperienceRankingVo item : ls) {
                            for (AccountVO aitem : acs) {
                                if (item.getAccountId().longValue() == aitem.getId().longValue()) {
                                    item.setOrgName(aitem.getOrgName());
                                    item.setFullName(aitem.getFullName());
                                    item.setName(aitem.getName());
                                    item.setSex(aitem.getSex());
                                    break;
                                }
                            }
                        }
                    } else {
                        LOGGER.info("call System ok：0");
                    }
                }
            } catch (Exception e) {
                LOGGER.info("调用System服务，更新用户信息失败");
                e.printStackTrace();
            }

            return Response.ok(page.getRecords(), pageMap);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "个人经验明细", notes = "个人经验明细", response = MyExperienceEventsVo.class)
    @GetMapping("/experience/dtl")
    public Response<MyExperienceEventsVo> getMyExperienceDtl(
            @ApiParam(value = "经验池ID", required = true) @RequestParam(name = "poolId", required = true) Long poolId,
            @ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            @ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {
        try {
            if (poolId == null) {
                return Response.fail();
            }

            if (pageNo == null || pageNo <= 0) {
                pageNo = 1;
            }
            if (pageSize == null || pageSize <= 0) {
                pageSize = 10;
            }

            Page<MyExperienceEventsVo> page = myExperienceClient.getMyExperienceDtl(poolId, pageSize, pageNo);
            Map<String, Integer> pageMap = new HashMap<String, Integer>();
            pageMap.put("pageNo", pageNo);
            pageMap.put("pageSize", pageSize);
            if (page == null) {
                pageMap.put("pageTotal", 0);
            } else {
                pageMap.put("pageTotal", page.getTotal());
            }

            return Response.ok(page.getRecords(), pageMap);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "个人经验等级分类", notes = "个人经验等级分类", response = MyExperienceLevelVo.class)
    @GetMapping("/experience/classify")
    public Response<MyExperienceLevelVo> getMyExperienceClassify(
            @ApiParam(value = "经验池ID", required = true) @RequestParam(name = "poolId", required = true) Long poolId,
            @ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            @ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {
        try {
            if (poolId == null) {
                return Response.fail();
            }

            if (pageNo == null || pageNo <= 0) {
                pageNo = 1;
            }
            if (pageSize == null || pageSize <= 0) {
                pageSize = 10;
            }

//            Map<String, Integer> pageMap = new HashMap<String, Integer>();
//            pageMap.put("pageNo", pageNo);
//            pageMap.put("pageSize", pageSize);

            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String currentTime = sdf.format(new Date());
            MyExperienceLevelVo level = myExperienceClient.getMyExperienceClassify(poolId, pageSize, pageNo);
            if (level == null) {
                level = new MyExperienceLevelVo();
                List<MyExperienceEventsVo> list = new ArrayList<>();
                level.setEventClassifys(list);
                level.setExperienceTotal(0);
                level.setLevelCode("");
                level.setLevelName("");
                level.setRanking("");
                level.setCurrentTime(currentTime);
                Response.ok(level);
            }

//            if (level.getEventClassifys() == null) {
//                pageMap.put("pageTotal", 0);
//            } else {
//                pageMap.put("pageTotal", level.getEventClassifys().getTotal());
//            }
            level.setCurrentTime(currentTime);
            return Response.ok(level);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "经验等级", notes = "经验等级", response = MyExperienceLevelVo.class)
    @GetMapping("/experience/level")
    public Response<MyExperienceLevelVo> getMyExperienceLevels(
            @ApiParam(value = "经验池ID", required = true) @RequestParam(name = "poolId", required = true) Long poolId) {
        try {
            if (poolId == null) {
                return Response.fail();
            }

            List<MyExperienceLevelVo> levels = myExperienceClient.getMyExperienceLevels(poolId);

            return Response.ok(levels);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "我的经验池登录信息", notes = "我的经验池登录信息", response = MyExperiencePoolVo.class)
    @GetMapping("/experience/login")
    public Response<MyExperiencePoolVo> getMyExperienceLogin(
            @ApiParam(value = "经验池ID", required = true) @RequestParam(name = "poolId", required = true) Long poolId) {
        try {
            if (poolId == null) {
                return Response.fail();
            }

            MyExperiencePoolVo login = myExperienceClient.getMyExperienceLogin(poolId);
            if (login == null) {
                login = new MyExperiencePoolVo();
                login.setAccountCode("");
                login.setFirstLogin(0);
                login.setMotto("");
                login.setNowTime(new Date());
                login.setStep(0);
            }

            return Response.ok(login);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "存步数", notes = "存步数", response = StudentExperiencePoolVo.class)
    @GetMapping("/experience/savestep")
    public Response<StudentExperiencePoolVo> saveMyExperienceStep(
            @ApiParam(value = "经验池ID", required = true) @RequestParam(name = "poolId", required = true) Long poolId,
            @ApiParam(value = "步数", required = true) @RequestParam(name = "step", required = true) Integer step) {
        try {
            if (poolId == null) {
                return Response.fail();
            }

            if (step == null) {
                return Response.fail();
            }

            StudentExperiencePoolVo pool = myExperienceClient.saveMyExperienceStep(poolId, step);
            if (pool == null) {
                return Response.fail();
            }

            return Response.ok(pool);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "存座右铭", notes = "存座右铭", response = StudentExperiencePoolVo.class)
    @GetMapping("/experience/savemotto")
    public Response<StudentExperiencePoolVo> saveMyExperienceMotto(
            @ApiParam(value = "经验池ID", required = true) @RequestParam(name = "poolId", required = true) Long poolId,
            @ApiParam(value = "座右铭", required = true) @RequestParam(name = "motto", required = true) String motto) {
        try {
            if (poolId == null) {
                return Response.fail();
            }

            if (StringUtils.isBlank(motto)) {
                return Response.fail();
            }

            StudentExperiencePoolVo pool = myExperienceClient.saveMyExperienceMotto(poolId, motto);
            if (pool == null) {
                return Response.fail();
            }

            return Response.ok(pool);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "任务完成情况API获取计划列表", notes = "任务完成情况API获取计划列表", response = TpPlanFinishedListVo.class)
    @GetMapping("/tpPlan/list")
    public Response<TpPlanFinishedListVo> tpPlanList(
            @ApiParam(value = "培训项目ID", required = true) @RequestParam(value = "projectId", required = true) Long projectId,
            @ApiParam(value = "当前每几页", required = false) @RequestParam(value = "pageNo", required = false, defaultValue = "1") Integer pageNo,
            @ApiParam(value = "每页条数", required = false) @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        try {
            Map<String, Integer> pageMap = new HashMap<>();
            Page<TpPlanFinishedListVo> page = new Page<>(pageNo, pageSize);
            page = tpPlanFinishedApiClient.tpPlanList(projectId, pageNo, pageSize);
            pageMap.put("pageNo", pageNo);
            pageMap.put("pageSize", pageSize);
            if (null != page) {
                pageMap.put("total", page.getTotal());
            } else {
                pageMap.put("total", 0);
            }
            return Response.ok(page.getRecords(), pageMap);
        } catch (Exception e) {
            LOGGER.error("############trainingProject服务调用异常", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "任务完成情况计划信息", notes = "任务完成情况计划信息", response = TpPlanFinishedVo.class)
    @GetMapping("/tpPlan/getTpPlanActivity")
    public Response<TpPlanFinishedVo> getTpPlanActivity(
            @ApiParam(value = "培训项目ID", required = true) @RequestParam(value = "projectId", required = true) Long projectId,
            @ApiParam(value = "计划ID", required = true) @RequestParam(value = "tpPlanId", required = true) Long tpPlanId) {
        try {
            TpPlanFinishedVo tpPlanFinishedVo = new TpPlanFinishedVo();
            tpPlanFinishedVo = tpPlanFinishedApiClient.getTpPlanActivity(projectId, tpPlanId);
            return Response.ok(tpPlanFinishedVo);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "任务完成情况点击活动", notes = "任务完成情况点击活动")
    @GetMapping("/tpPlan/clickActivity")
    public Response<Map<String, Object>> ClickActivity(
            @ApiParam(value = "任务活动id", required = true) @RequestParam(value = "activityId", required = true) Long activityId,
            @ApiParam(value = "计划id", required = true) @RequestParam(value = "tpPlanId", required = true) Long tpPlanId) {
        try {
            Map<String, Object> map = new HashMap<>();
            map = tpPlanFinishedApiClient.ClickActivity(activityId, tpPlanId);
            return Response.ok(map);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiModelProperty(value = "自定义项目验证用户培训项目权限", notes = "自定义项目验证用户培训项目权限")
    @GetMapping("/tpPlan/getRange")
    public Response<Object> getRange(@ApiParam(value = "培训项目id", required = true) @RequestParam(value = "projectId", required = true) Long projectId) {
        try {
            Integer isPass = tpProjectClient.getCustomProjectRange(projectId);
            return Response.ok(isPass);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiModelProperty(value = "自定义项目按部门/组别,分组经验排名", notes = "自定义项目按部门分组经验排名")
    @GetMapping("/experience/orgRanking")
    public Response<Object> getOrgRanking(@RequestParam(value = "poolId") Long poolId,
                                          @RequestParam(value = "pageNo") Integer pageNo,
                                          @RequestParam(value = "pageSize") Integer pageSize,
                                          @ApiParam(value = "请求类型:0:按部门 1:按小组 2:按小组,可给小组导入经验", required = true) @RequestParam(value = "type", required = false, defaultValue = "0") Integer type) {
        try {
            Map<String, Integer> pageMap = new HashMap<>(3);
            pageMap.put("pageNo", pageNo);
            pageMap.put("pageSize", pageSize);
            //0按部门 1按组别 2按小组,可给小组导入经验
            Page<ExperienceOrgRankingVO> page = myExperienceClient.getOrgRanking(poolId, pageNo, pageSize, type);
            if (null != page) {
                pageMap.put("total", page.getTotal());
                return Response.ok(page.getRecords(), pageMap);
            }
            return Response.ok(null);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiModelProperty(value = "自定义项目获取课程评论数量", notes = "自定义项目获取课程评论数量")
    @PostMapping("/course/getCount")
    public Response<List<Integer>> getCount(@ApiParam(value = "课程ids", required = true) @RequestBody List<Long> courseIds) {
        return Response.ok(commClient.countComm(courseIds));
    }

    @ApiModelProperty(value = "自定义项目获取用户组别,批次,备注信息", notes = "自定义项目获取用户组别,批次,备注信息")
    @GetMapping("/experience/getBatchGroup")
    public Response<Object> getBatchGroup(@ApiParam(value = "用户id", required = true) @RequestParam(value = "accountId", required = true) Long accountId,
                                          @ApiParam(value = "经验池id", required = true) @RequestParam(value = "poolId", required = true) Long poolId) {
        return Response.ok(myExperienceClient.getBatchGroup(accountId, poolId));
    }

    @ApiModelProperty(value = "自定义项目获取商品信息", notes = "自定义项目获取商品信息")
    @GetMapping("/getProducts")
    public Response<Object> getProducts(@ApiParam(value = "经验池id", required = true) @RequestParam(value = "poolId", required = true) Long poolId) {
        try {
            return Response.ok(purchaseProductClient.getProducts(poolId));
        } catch (Exception e) {
            LOGGER.error("############自定义项目服务调用异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "自定义项目购买商品", notes = "自定义项目购买商品")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "poolId", value = "经验池id", paramType = "body", required = true),
            @ApiImplicitParam(name = "id", value = "商品id", paramType = "body", required = true),
            @ApiImplicitParam(name = "amount", value = "购买数量", paramType = "body", required = true)
    })
    @PostMapping("/purchaseProducts")
    Response<Object> purchaseProducts(@RequestBody PurchaseProductsParam purchaseProductsParam) {

        try {
            String result = purchaseProductClient.purchaseProducts(purchaseProductsParam);
            return Response.ok(result);
        } catch (Exception e) {
            LOGGER.error("############自定义项目服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiModelProperty(value = "自定义项目获取课程收藏数", notes = "自定义项目获取课程收藏数")
    @GetMapping("/getCourseFavoriteCount")
    public Response<Object> getCourseFavoriteCount() {
        try {
            RequestContext res = ContextHolder.get();
            Integer num = courseClient.getMyFavoriteCount(res.getAccountId(), res.getCompanyId(), res.getSiteId());
            return Response.ok(num);
        } catch (Exception e) {
            LOGGER.error("############自定义项目服务调用异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiModelProperty(value = "复旦mini mba项目获取项目完成情况", notes = "复旦mini mba项目获取项目完成情况")
    @PostMapping("/projects/status")
    public Response<Object> getProjectsStatus(@RequestBody List<Long> projectIds) {
        try {
            List<TpStudentProjectRecordVoVO> recordList = null;
            if (CollectionUtils.isNotEmpty(projectIds)) {
                recordList = tpPlanFinishedApiClient.getProjectsStatus(projectIds);
            }
            return Response.ok(recordList);
        } catch (Exception e) {
            LOGGER.error("############trainingProject服务调用异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiModelProperty(value = "复旦mini mba项目获取正在学习人数", notes = "复旦mini mba项目获取正在学习人数")
    @PostMapping("/projects/studyingNum")
    public Response<Object> getProjectsStudyingNum(@RequestBody List<Long> projectIds) {
        try {
            Integer num = 0;
            if (CollectionUtils.isNotEmpty(projectIds)) {
                num = tpPlanFinishedApiClient.getProjectsStudyingNum(projectIds);
            }
            return Response.ok(num);
        } catch (Exception e) {
            LOGGER.error("############trainingProject服务调用异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiModelProperty(value = "复旦mini mba项目获取用户信息/日签用户信息", notes = "复旦mini mba项目获取用户信息/日签用户信息")
    @PostMapping("/projects/userDetails")
    public Response<Object> getUserDetails(@RequestBody ProjectsDurationParamVO paramVO) {
        try {
            ProjectsUserDetailsVO projectsUserDetailsVO = new ProjectsUserDetailsVO();

            RequestContext res = ContextHolder.get();
            AccountVO accountVO = accountClient.findById(res.getAccountId());
            if (null != accountVO) {
                projectsUserDetailsVO.setAccountFullName(accountVO.getFullName());
                projectsUserDetailsVO.setHeadPortrait(accountVO.getHeadPortrait());
            }

            if (CollectionUtils.isNotEmpty(paramVO.getBizIds())) {
                MinimbaUserDetailParamVO detailParamVO = new MinimbaUserDetailParamVO();
                detailParamVO.setIsRealTime(paramVO.getIsRealTime());
                detailParamVO.setProjectIds(paramVO.getBizIds());
                //获取打卡,点赞,计划完成百分比
                MinimbaUserDetailVO minimbaUserDetailVO = minimbaClient.getUserDetails(detailParamVO);
                if (null != minimbaUserDetailVO) {
                    projectsUserDetailsVO.setPraisedNum(minimbaUserDetailVO.getPraisedNum());
                    projectsUserDetailsVO.setPushInNum(minimbaUserDetailVO.getPushInNum());
                    projectsUserDetailsVO.setPercentage(minimbaUserDetailVO.getPercentage());
                }

                //获取总学习时长
                Integer totalDuration = courseStudyClient.getProjectsTotalDuration(paramVO);
                projectsUserDetailsVO.setStudyTotalDuration(totalDuration);
            } else {
                projectsUserDetailsVO.setStudyTotalDuration(0);
                projectsUserDetailsVO.setPercentage(0);
                projectsUserDetailsVO.setPushInNum(0);
                projectsUserDetailsVO.setPraisedNum(0);
            }
            return Response.ok(projectsUserDetailsVO);
        } catch (Exception e) {
            LOGGER.error("############trainingProject服务调用异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiModelProperty(value = "复旦mini mba项目获取学习记录", notes = "复旦mini mba项目获取学习记录")
    @PostMapping("/projects/studyingRecords")
    public Response<Object> getProjectsStudyingRecords(@RequestBody List<Long> projectIds) {
        try {
            List<TpStudentProjectRecordVoVO> list = null;
            if (CollectionUtils.isNotEmpty(projectIds)) {
                list = tpPlanFinishedApiClient.getProjectsStudyingRecords(projectIds);
            }
            return Response.ok(list);
        } catch (Exception e) {
            LOGGER.error("############trainingProject服务调用异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "点一个项目,获取学习记录", notes = "点一个项目,获取学习记录")
    @GetMapping("/project/studyingRecords")
    public Response<Object> getProjectStudyingRecords(
            @ApiParam(value = "培训项目ID", required = true) @RequestParam(value = "projectId", required = true) Long projectId) {
        try {
            List<MinimbaStudyRecordVO> list = null;

            list = minimbaClient.getProjectStudyingRecords(projectId);

            if (CollectionUtils.isNotEmpty(list)) {
                Map<Long, Map<String, Object>> durationMap = new HashMap<>(16);
                Map<Long, Map<String, Object>> examScoreMap = new HashMap<>(16);

                List<Long> courseIds = new ArrayList<>();
                List<Long> examIds = new ArrayList<>();

                for (MinimbaStudyRecordVO minimbaStudyRecordVO : list) {
                    if (null != minimbaStudyRecordVO.getCourseId()) {
                        courseIds.add(minimbaStudyRecordVO.getCourseId());
                    }
                    if (null != minimbaStudyRecordVO.getExamId()) {
                        examIds.add(minimbaStudyRecordVO.getExamId());
                    }
                }

                if (CollectionUtils.isNotEmpty(courseIds)) {
                    ProjectsDurationParamVO paramVO = new ProjectsDurationParamVO();
                    paramVO.setBizIds(courseIds);
                    //获取总学习时长
                    durationMap = courseStudyClient.getCourseTotalDuration(paramVO);
                }

                if (CollectionUtils.isNotEmpty(examIds)) {
                    //获取考试最高分
                    examScoreMap = examClient.getMaxScores(examIds);
                }


                for (MinimbaStudyRecordVO minimbaStudyRecordVO : list) {
                    Map<String, Object> map1 = null;
                    Map<String, Object> map2 = null;
                    if (null != durationMap) {
                        map1 = durationMap.get(minimbaStudyRecordVO.getCourseId());
                    }
                    if (null != examScoreMap) {
                        map2 = examScoreMap.get(minimbaStudyRecordVO.getExamId());
                    }

                    if (null != map1) {
                        String duration = (String) map1.get("duration");
                        minimbaStudyRecordVO.setCourseStudyDuration(duration);
                    } else {
                        minimbaStudyRecordVO.setCourseStudyDuration("0秒");
                    }
                    if (null != map2) {
                        Double score = (Double) map2.get("score");
                        minimbaStudyRecordVO.setCourseScore(score);
                    } else {
                        minimbaStudyRecordVO.setCourseScore((double) 0);
                    }
                }
            }

            return Response.ok(list);
        } catch (Exception e) {
            LOGGER.error("############服务调用异常", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "嘉兴银行闯关排行", notes = "嘉兴银行闯关排行")
    @GetMapping("/jiaxing/rankings")
    public Response<Object> getRankings(
            @ApiParam(value = "课程id", required = true) @RequestParam(value = "courseId", required = true) Long courseId,
            @ApiParam(value = "当前页数", required = true) @RequestParam(value = "pageNo", required = true) Integer pageNo,
            @ApiParam(value = "每页记录数", required = true) @RequestParam(value = "pageSize", required = true) Integer pageSize) {

        try {
            Page<JaxinRankingVO> page = courseClient.getRankings(courseId, pageNo, pageSize);
            List<JaxinRankingVO> list = null;
            if (null == page) {
                return Response.ok(list);
            }

            list = page.getRecords();

            if (CollectionUtils.isNotEmpty(list)) {

                RequestContext res = ContextHolder.get();
                Map<Long, ReportAccountRespVO> accountMap = new HashMap<>(16);

                List<Long> accountIds = list.stream().map(JaxinRankingVO::getAccountId).collect(Collectors.toList());
                ReportRangeAccountReqVO reqVO = new ReportRangeAccountReqVO();
                reqVO.setAccountIds(accountIds);
                reqVO.setSiteId(res.getSiteId());
                //获取用户信息

                List<ReportAccountRespVO> accountRespVOList = reportClient.getRangeAccounts(reqVO);
                if (CollectionUtils.isNotEmpty(accountRespVOList)) {
                    for (ReportAccountRespVO accountRespVO : accountRespVOList) {
                        accountMap.put(accountRespVO.getUserId(), accountRespVO);
                    }
                }

                //组装用户信息
                for (JaxinRankingVO jaxinRankingVO : list) {
                    ReportAccountRespVO accountRespVO = accountMap.get(jaxinRankingVO.getAccountId());
                    if (null != accountRespVO) {
                        jaxinRankingVO.setAccountName(accountRespVO.getUserName());
                        jaxinRankingVO.setAccountFullName(accountRespVO.getUserFullName());
                    }
                }
            }
            return Response.ok(list);
        } catch (Exception e) {
            LOGGER.error("############course服务调用异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

}
