//package com.yizhi.application.wechat.controller;
//
//import com.yizhi.application.context.ContextHolder;
//import com.yizhi.application.context.RequestContext;
//import com.yizhi.application.entity.PublicPlatformConfig;
//import com.yizhi.application.entity.TrAccountUserinfo;
//import com.yizhi.application.feign.WeiXinClient;
//import com.yizhi.application.system.domain.Account;
//import com.yizhi.application.system.remote.AccountClient;
//import com.yizhi.application.system.remote.CompanyClient;
//import com.yizhi.application.system.remote.LoginLogClient;
//import com.yizhi.application.system.remote.SiteClient;
//import com.yizhi.application.token.TokenHelper;
//import com.yizhi.application.util.constant.GlobalConstant;
//import com.yizhi.application.util.constant.ReturnCode;
//import com.yizhi.application.util.domain.Response;
//import com.yizhi.application.vo.AccountVO;
//import com.yizhi.application.vo.CompanyVO;
//import com.yizhi.application.vo.WeChatUserVO;
//import com.yizhi.application.wechat.utils.WechatInfoService;
//import io.swagger.annotations.Api;
//import io.swagger.annotations.ApiOperation;
//import io.swagger.annotations.ApiParam;
//import org.apache.commons.lang3.StringUtils;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.BeanUtils;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.beans.factory.annotation.Value;
//import org.springframework.web.bind.annotation.GetMapping;
//import org.springframework.web.bind.annotation.RequestMapping;
//import org.springframework.web.bind.annotation.RequestParam;
//import org.springframework.web.bind.annotation.RestController;
//
//import javax.servlet.http.HttpServletResponse;
//import java.util.HashMap;
//import java.util.Map;
//
///**
// * @description: 自定义项目
// * @author: lly
// * @date: 2019-09-29 17:56
// **/
//@RestController
//@Api(tags = "自定义项目的接口")
//@RequestMapping("/wechat/customproject")
//public class CustomController {
//
//    private static final Logger LOGGER = LoggerFactory.getLogger(WechatLoginController.class);
//
//    @Autowired
//    private WeiXinClient weiXinClient;
//
//    @Autowired
//    private TokenHelper tokenHelper;
//
//    @Autowired
//    private AccountClient accountClient;
//
//    @Autowired
//    private CompanyClient companyClient;
//
//    @Autowired
//    private SiteClient siteClient;
//
//    @Autowired
//    LoginLogClient loginLogClient;
//
//    @Autowired
//    WechatInfoService wechatInfoService;
//
//    @Autowired
//    WechatLoginController wechatController;
//
//
//    @Value("${wechat.account.initializtion.pwd}")
//    private String password;
//
//
//    @ApiOperation(value = "查询用户是否在系统中", notes = "查询用户是否在系统中")
//    @GetMapping(value = "/get")
//    public Response<String> queryUserInWechat(HttpServletResponse httpResponse,
//                                              @ApiParam(name = "wechatUserId", value = "用户openid", required = true)
//                                              @RequestParam(name = "wechatUserId", required = true) String wechatUserId,
//                                              @ApiParam(name = "appid", value = "公众号的APPID或者是企业服务号的CorpID", required = true)
//                                              @RequestParam(name = "appid") String appid,
//                                              @ApiParam(name = "agentId", value = "机构Id", required = false)
//                                              @RequestParam(name = "agentId") String agentId) {
//
//
//
//        LOGGER.info("参数wechatUserId:"+wechatUserId+"参数appid："+appid);
//
//        RequestContext context = ContextHolder.get();
//        //获取企业的信息
//        CompanyVO companyVO = companyClient.findByCode(context.getCompanyCode());
//        //获取用户绑定信息
//        TrAccountUserinfo trAccountUserinfo = weiXinClient.queryUserInWechat(wechatUserId,companyVO.getId());
//
//        //判断条件
//        if (trAccountUserinfo != null) {
//            // modify @ 2018年12月28日16:00:16
//            //判断企业用户 企业用户更新信息
//            if (StringUtils.isNotBlank(agentId)){
//                Map<String, String> map = new HashMap<String,String>();
//                map.put("appid",appid);
//                map.put("agentId",agentId);
//                map.put("accountId",trAccountUserinfo.getAccountId().toString());
//                map.put("wechatUserId",wechatUserId);
//
//                wechatInfoService.execute(map,true);
//            }
//
//            LOGGER.info("该微信用户已经绑定未木云账号：" + trAccountUserinfo.getAccountId());
//
//
//            // 判断该用户是是否有 站点的访问权限
//            if (wechatController.getSiteAuthorize(trAccountUserinfo.getAccountId(),context.getSiteId(),companyVO.getId())) {
//                // 有站点访问权限
//
//                if(trAccountUserinfo.getSiteId()==null){
//                    trAccountUserinfo.setSiteId(context.getSiteId());
//                    weiXinClient.updateUserInWechat(trAccountUserinfo);
//                }
//
//                //如果用户存在微服务系统中
//                //生成token
//                //获取用户信息
//                AccountVO accountVO = accountClient.findById(trAccountUserinfo.getAccountId());
//
//
//                Map<String, Object> info = new HashMap<String, Object>();
//
//                info.put(GlobalConstant.ACCOUNT_ID, trAccountUserinfo.getAccountId().toString());
//
//                info.put(GlobalConstant.COMPANY_CODE, context.getCompanyCode());
//                info.put(GlobalConstant.COMPANY_ID, companyVO.getId().toString());
//                info.put(GlobalConstant.COMPANY_NAME, companyVO.getName());
//                info.put(GlobalConstant.SITE_ID, context.getSiteId().toString());
//                LOGGER.info("companyCode:" + context.getCompanyCode() + ",COMPANY_ID" + companyVO.getId().toString() + ",CompanyName:" + context.getCompanyName());
//
//
//                context.setAccountId(trAccountUserinfo.getAccountId());
//                //生成token
//                String token = tokenHelper.createToken(accountVO.getName(), info);
//
//
//                Map<String, Object> retMap = new HashMap<>();
//                httpResponse.addHeader(GlobalConstant.TOKEN_HEADER, token);
//                retMap.put(GlobalConstant.TOKEN_HEADER, token);
//                retMap.put("userInfo", accountVO);
//                ContextHolder.set(context);
//                //返回用户信息和token
//                return Response.ok(retMap);
//            } else {
//                return Response.fail(ReturnCode.NOT_SITE_AUTH);
//            }
//        } else {
//            // 不存在账号
//            LOGGER.info("该微信的wechatUserId:"+wechatUserId+"未绑定未木云的系统账号");
//
//            PublicPlatformConfig publicPlatformConfig = weiXinClient.getPlatformconfig(appid,agentId);
//            // 企业用户微信和 类型为自动新增
//            if ("0".equals(publicPlatformConfig.getType())&&publicPlatformConfig.getIsAddedUser() == 1) {
//                // 查询未木云系统中是否存在此企业和用户名的用户
//                AccountVO userInfo = accountClient.findUser(wechatUserId,companyVO.getId());
//
//                //生成token
//                Map<String, Object> retMap = new HashMap<>();
//                if (userInfo!=null) {
//
//                    LOGGER.info(wechatUserId+" exist in system!!!!!");
//                    //系统中存在用户自动建立关联关系
//                    LOGGER.info("参数"+wechatUserId+"；用户id："+userInfo.getId()+"站点id："+context.getSiteId()+";公司companyId："+context.getCompanyId());
//                    weiXinClient.saveTrAccountUserinfo(wechatUserId,userInfo.getId(),context.getSiteId(),companyVO.getId(),5);
//
//                    //生成token
//                    Map<String, Object> info = new HashMap<String, Object>();
//                    info.put(GlobalConstant.ACCOUNT_ID, userInfo.getId().toString());
//                    info.put(GlobalConstant.COMPANY_CODE, context.getCompanyCode());
//                    info.put(GlobalConstant.COMPANY_ID, companyVO.getId().toString());
//                    info.put(GlobalConstant.COMPANY_NAME, companyVO.getName());
//                    info.put(GlobalConstant.SITE_ID,context.getSiteId().toString());
//
//                    context.setAccountId(userInfo.getId());
//                    String token = tokenHelper.createToken(userInfo.getName(), info);
//                    // 统计登录调用接口
//
//
//
//                    httpResponse.addHeader(GlobalConstant.TOKEN_HEADER, token);
//                    retMap.put(GlobalConstant.TOKEN_HEADER, token);
//                    retMap.put("userInfo", userInfo);
//                    ContextHolder.set(context);
//                } else {
//                    // 系统中不存在用户
//                    LOGGER.info("there are no username is"+wechatUserId+" in system!");
//                    String accessToken = weiXinClient.getChatAccessToken(publicPlatformConfig);
//                    LOGGER.info("获取当前的accessToken："+accessToken);
//                    // 查询用户的信息
//                    WeChatUserVO weChatUserVO = weiXinClient.getWechatUser(accessToken,wechatUserId);
//
//                    Account account = null;
//                    if (weChatUserVO!=null) {
//                        // 新增用户和用户对应的组织
//                        account = accountClient.saveUser(weChatUserVO);
//                    }
//
//                    AccountVO accountVO = new AccountVO();
//                    BeanUtils.copyProperties(account,accountVO);
//                    if (account != null) {
//                        try {
//                            // 生成站点访问权限
//                            Boolean b = siteClient.relateAccountSite(context.getSiteId(),account.getId(),context.getCompanyCode());
//                            LOGGER.info("访问权限生成::"+b );
//
//                            // 新增用戶微信关联
//                            weiXinClient.saveTrAccountUserinfo(wechatUserId,accountVO.getId(),context.getSiteId(),companyVO.getId(),5);
//                            LOGGER.info("企业微信用户的关联已经生成。");
//
//                        } catch (Exception e) {
//                            LOGGER.info(e.toString());
//                        }
//                        LOGGER.info("访问权限生成.");
//
//
//                        //生成token
//                        Map<String, Object> info = new HashMap<String, Object>();
//                        info.put(GlobalConstant.ACCOUNT_ID, accountVO.getId().toString());
//                        info.put(GlobalConstant.COMPANY_CODE, context.getCompanyCode());
//                        info.put(GlobalConstant.COMPANY_ID, companyVO.getId().toString());
//                        info.put(GlobalConstant.COMPANY_NAME, companyVO.getName());
//                        info.put(GlobalConstant.SITE_ID,context.getSiteId().toString());
//
//                        context.setAccountId(account.getId());
//                        String token = tokenHelper.createToken(account.getName(), info);
//
//                        httpResponse.addHeader(GlobalConstant.TOKEN_HEADER, token);
//                        retMap.put(GlobalConstant.TOKEN_HEADER, token);
//                        retMap.put("userInfo", accountVO);
//                        ContextHolder.set(context);
//                    }
//                }
//                return Response.ok(retMap);
//            } else {
//                LOGGER.info("当前的微信号未关联系统账号");
//                return Response.fail(ReturnCode.NOT_RELATE_ACCOUNT);
//            }
//        }
//    }
//
//}
