/**
 * FileName: ScormThread
 * Author:   wenjunlong
 * Date:     2018/7/16 15:00
 * Description: scorm文件上传处理线程
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.application.course.util;

import org.springframework.beans.factory.annotation.Value;

import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈scorm文件上传处理线程〉
 *
 * @author wenjunlong
 * @create 2018/7/16
 * @since 1.0.0
 */
public class ScormThread extends Thread{

    @Value("${ACTIVE}")
    public String active;

    private List<String> fileList;

    public ScormThread(List<String> fileList) {
        this.fileList = fileList;
    }

    @Override
    public void run() {
        for (String fileStr : fileList) {
            String key = "scorm" + fileStr.split("scorm")[1].replaceAll("\\\\", "/");
            System.out.println(key);
            String result = OssUpload.upload(fileStr, key,active);
            System.out.println("key="+key+", fileStr="+fileStr+" ,result="+result);
        }
    }
}
