package com.yizhi.application.lecturer.Controller;


import com.yizhi.lecturer.application.enums.DeleteFlag;
import com.yizhi.lecturer.application.feign.LecturerClassificationClient;
import com.yizhi.lecturer.application.vo.LecturerClassificationRespVO;
import com.yizhi.lecturer.application.vo.LecturerClassificationVO;
import com.yizhi.lecturer.application.vo.LecturerSortVO;
import com.yizhi.lecturer.application.vo.domain.LecturerResponseVo;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.log4j.Log4j2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @description: 讲师库字典
 * @author: lly
 * @date: 2019-04-18 11:50
 **/
@Log4j2
@Api(tags = "讲师库分类")
@RestController
@RequestMapping("/manage/lecturer/classification")
public class LecturerClassificationController {
    private static final Logger LOG = LoggerFactory.getLogger(LecturerClassificationController.class);

    @Autowired
    private LecturerClassificationClient classificationClient;

    /**
     * 分类列表
     *
     * @param type
     * @return
     */
    @GetMapping(value = "/list")
    public Response<String> getClassificationList(@ApiParam(name = "type", value = "type为0,上架分类，不传或者其他参数为所以分类",required = false) @RequestParam(name = "type", required = false, defaultValue = "1") Integer type) {
        return Response.ok(classificationClient.getClassificationList(type));
    }

    /**
     * 分类新增
     *
     * @param lecturerClassificationVO
     * @return
     */
    @ApiOperation(value = "分类新增", notes = "分类新增", response = LecturerClassificationVO.class)
    @PostMapping(value = "/add")
    public Response<LecturerClassificationVO> addClassification(@RequestBody LecturerClassificationVO lecturerClassificationVO) {
        LecturerClassificationVO vo = null;
        try {
            vo = classificationClient.addClassification(lecturerClassificationVO);
            return Response.ok(vo);
        } catch (Exception e) {
            return Response.fail(Constants.LECTURER_MSG_BIZ_ERROR);
        }
    }

    /**
     * 分类修改
     *
     * @param lecturerClassificationVO
     * @return
     */
    @ApiOperation(value = "分类修改", notes = "分类修改", response = LecturerClassificationVO.class)
    @PostMapping(value = "/update")
    public Response<LecturerClassificationVO> updateClassification(@RequestBody LecturerClassificationVO lecturerClassificationVO) {
        LecturerClassificationVO vo = null;
        try {
            vo = classificationClient.updateClassification(lecturerClassificationVO);
            return Response.ok(vo);
        } catch (Exception e) {
            return Response.fail(Constants.LECTURER_MSG_BIZ_ERROR);
        }

    }

    @ApiOperation(value = "分类上下架", notes = "分类上下架", response = LecturerClassificationVO.class)
    @PostMapping(value = "/upOrDown")
    public Response<LecturerClassificationVO> upOrDown(@RequestBody LecturerClassificationVO lecturerClassificationVO) {
        LecturerClassificationRespVO vo = null;
        try {
            vo = classificationClient.upOrDown(lecturerClassificationVO);
            LOG.info("返回的信息vo",vo);
            if (vo.getCode()!= DeleteFlag.NO.ordinal()) {
                return Response.ok();
            } else {
                return Response.fail(Constants.LECTURER_CLASSIFICATION_UP_ERROR);
            }
        } catch (Exception e) {
            LOG.info("返回的信息",e);
            return Response.fail(Constants.LECTURER_MSG_BIZ_ERROR);
        }

    }

    /**
     * 分类删除
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "分类删除", notes = "分类删除")
    @GetMapping(value = "/del")
    public Response<String> del(@ApiParam(value = "分类id", name = "id") @RequestParam String id) {
        LecturerResponseVo delResult = null;
        try {
            delResult = classificationClient.del(Long.valueOf(id));
            if (delResult.getCode().equals("success")) {
                return Response.ok();
            } else {
                return Response.fail(delResult.getMsg());
            }
        } catch (Exception e) {
            return Response.fail(Constants.LECTURER_MSG_BIZ_ERROR);
        }
    }

    /**
     * 分类移动
     * @param lecturerSortVO
     * @return
     */
    @ApiOperation(value = "分类移动", notes = "分类移动", response = LecturerSortVO.class)
    @PostMapping(value = "/classification/sort")
    public Response sort(@RequestBody LecturerSortVO lecturerSortVO) {

        try {
            Boolean sort = classificationClient.sort(lecturerSortVO);
            return Response.ok();
        } catch (Exception e) {
            return Response.fail(Constants.LECTURER_MSG_BIZ_ERROR);
        }

    }


    @ApiOperation(value = "获取分类详情", notes = "获取分类详情")
    @GetMapping(value = "/get/id")
    public Response getById(@ApiParam(value = "分类id", name = "id") @RequestParam(name="id") Long id) {

        try {

            return Response.ok(classificationClient.getById(id));
        } catch (Exception e) {
            return Response.fail(Constants.LECTURER_MSG_BIZ_ERROR);
        }

    }
}