package com.yizhi.application.album;

import java.util.ArrayList;
import java.util.List;

import com.yizhi.album.application.feign.AlbumClassifyClient;
import com.yizhi.album.application.feign.ClassifyStrategyClient;
import com.yizhi.album.application.vo.AlbumClassifyVo;
import com.yizhi.album.application.vo.ApiAlbumClassifyVo;
import com.yizhi.album.application.vo.domain.AlbumClassify;
import com.yizhi.album.application.vo.domain.ClassifyStrategy;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.util.application.domain.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.plugins.Page;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(tags="学员端-专辑分类api",description="学员端-专辑分类接口")
@RestController
@RequestMapping("/api/albumClassify")
public class AlbumClassifyController {

	@Autowired
	private AlbumClassifyClient albumClassifyClient;
	
	@Autowired
	private ClassifyStrategyClient classifyStrategyClient;
	
    @ApiOperation(value = "学员端课程分类",response = ApiAlbumClassifyVo.class)
    @RequestMapping(value = "/list",method = RequestMethod.GET)
    public Response<String> listStudentCourse(){

        RequestContext requestContext = ContextHolder.get();
        Page<ApiAlbumClassifyVo> page = albumClassifyClient.pageList(null,1,999,requestContext.getCompanyId(),requestContext.getSiteId(),null);
        List<ApiAlbumClassifyVo> apiClassifyVos = new ArrayList<>();
        for (ApiAlbumClassifyVo apiClassifyVo : page.getRecords()) {
            apiClassifyVos.add(apiClassifyVo);
            if (null != apiClassifyVo.getChildren()&&apiClassifyVo.getChildren().size()>0) {
                for (ApiAlbumClassifyVo childApiClassifyVo : apiClassifyVo.getChildren()) {
                    apiClassifyVos.add(childApiClassifyVo);
                    if (null != childApiClassifyVo.getChildren() && childApiClassifyVo.getChildren().size() > 0) {
                        apiClassifyVos.addAll(childApiClassifyVo.getChildren());
                        childApiClassifyVo.setChildren(null);
                    }
                }
                apiClassifyVo.setChildren(null);
            }
        }
        return Response.ok(apiClassifyVos);
    }

    @ApiOperation(value = "根据专辑分类id查询分类名称")
    @GetMapping("/find/id")
    public Response<String> getById(@ApiParam(value = "专辑分类id") @RequestParam("id") Long id){
        AlbumClassify classify = albumClassifyClient.getById(id);
        return Response.ok(classify.getName());
    }

    @ApiOperation(value = "返回专辑分类策略", response = ClassifyStrategy.class)
    @GetMapping("/getStrategy")
    public Response<String> getStrategy(){
    	RequestContext context = ContextHolder.get();
    	Long siteId = context.getSiteId();
    	Long companyId = context.getCompanyId();
    	ClassifyStrategy strategy = classifyStrategyClient.get(companyId, siteId);
    	if (strategy==null) {
    		strategy = new ClassifyStrategy();
        	strategy.setStatus(0);
        	strategy.setType(0);
		}
        return Response.ok(strategy);
    }
    
    @ApiOperation(value = "pc专辑分类列表", response = AlbumClassifyVo.class)
    @GetMapping("/pc/list")
    public Response<AlbumClassifyVo> listClassifyInfo(
            @ApiParam(name = "classifyId", value = "专辑分类Id，不传查询全部一级分类", required = false)
            @RequestParam(value="classifyId",required = false) Long classifyId){
        List<AlbumClassifyVo> data = albumClassifyClient.listClassifyInfo(classifyId);
        return Response.ok(data);
    }
}
