package com.yizhi.application.language;

import java.util.List;

import com.yizhi.system.application.system.remote.LanguageClassifyClient;
import com.yizhi.system.application.vo.domain.LanguageClassify;
import com.yizhi.util.application.domain.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping("/api/language")
public class LanguageController {

	private static final Logger logger = LoggerFactory.getLogger(LanguageController.class);
	
	@Autowired
	private LanguageClassifyClient languageClassifyClient;
	
	@ApiOperation(value = "学员端语种列表",notes = "学员端语种列表")
	@GetMapping("/list")
	public Response<String> list(@RequestParam(name = "type",defaultValue = "1")Integer type){
		List<LanguageClassify> list = languageClassifyClient.list(type);
		return Response.ok(list);
	}
}
