package com.yizhi.application.offlineCourse.controller;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.OfflineCourseClient;
import com.yizhi.course.application.vo.OfflineCourseStudentVo;
import com.yizhi.course.application.vo.OfflineCourseVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "学员端-线下课程", description = "线下课程接口")
@RestController
@RequestMapping("/api/offlineCourse")
public class OfflineCourseController {

    @Autowired
    private OfflineCourseClient offlineCourseClient;

    @GetMapping("/get")
    @ApiOperation(value = "线下学员端课程查看", notes = "查看操作", response = OfflineCourseStudentVo.class)
    public Response get(
            @ApiParam(name = "id", value = "课程接受参数对象") @RequestParam(name = "id") Long id
    ) {
        RequestContext requestContext = ContextHolder.get();
        OfflineCourseStudentVo courseVo = offlineCourseClient.getList(id);
        return Response.ok(courseVo);
    }


    @GetMapping("/get/offlineCourse")
    @ApiOperation(value = "线下课程详情页查询", notes = "查看操作", response = OfflineCourseVo.class)
    public Response getOfflineDetail(@ApiParam(name = "id", value = "线下课程id") @RequestParam(name = "id") Long id){
        OfflineCourseVo offlineDetail = offlineCourseClient.getCourseById(id);
        return Response.ok(offlineDetail);
    }


    @GetMapping("/pc/get")
    @ApiOperation(value = "线下学员端课程查看", notes = "查看操作", response = OfflineCourseStudentVo.class)
    public Response getPcList(
            @ApiParam(name = "id", value = "课程接受参数对象") @RequestParam(name = "id") Long id
    ) {
        RequestContext requestContext = ContextHolder.get();
        OfflineCourseStudentVo courseVo = offlineCourseClient.getPcList(id);
        return Response.ok(courseVo);
    }
}
