package com.yizhi.application.point.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.point.util.PointUserExport;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.point.application.feign.PointUserFeignClients;
import com.yizhi.point.application.vo.*;
import com.yizhi.point.application.vo.domain.PointProductVo;
import com.yizhi.site.application.vo.domain.PublicationVo;
import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.system.application.system.remote.OrganizationClient;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@RestController
@Api(tags = "报表统计-积分排名", description = "报表统计-积分排名")
@RequestMapping("/manage/point/user")
public class PointUserController {

    private static final Logger LOG = LoggerFactory.getLogger(PointUserController.class);

    @Autowired
    private PointUserFeignClients pointUserClients;
    @Autowired
    private AccountClient accountClient;
    @Autowired
    private PointUserExport pointUserExport;
    @Autowired
    private OrganizationClient organizationClient;

    @ApiOperation(value = "积分排名列表", notes = "积分排名列表")
    @GetMapping("/rank/list")
    public Response<PointUserListVO> userRankList(
            @ApiParam(value = "用户名", required = false) @RequestParam(value = "userName", required = false) String userName,
            @ApiParam(value = "部门关键字", required = false) @RequestParam(value = "orgNameLike", required = false) String orgNameLike,
            @ApiParam(value = "当前第几页", required = false) @RequestParam(value = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam(value = "每页信息数 ", required = false) @RequestParam(value = "pageSize", defaultValue = "20") Integer pageSize,
            @ApiParam(value = "开始时间戳 毫秒值 ", required = false) @RequestParam(value = "startAt",required = false) Long startAt,
            @ApiParam(value = "结束时间戳 毫秒值 ", required = false) @RequestParam(value = "endAt",required = false) Long endAt) {
        PointUserParamVO vo = new PointUserParamVO();
        RequestContext context = ContextHolder.get();
        Long companyId = context.getCompanyId();
        vo.setPageNo(pageNo);
        vo.setPageSize(pageSize);
        vo.setSiteId(context.getSiteId());
        vo.setCompanyId(companyId);
        vo.setOrgId(context.getOrgId());
        vo.setAccountId(context.getAccountId());
        vo.setEndAt(null == endAt ? new Date() : new Date(endAt));
        vo.setStartAt(null == startAt ? DateUtil.parse("2016-01-01 00:00:00", "yyyy-MM-dd hh:mm:ss") : new Date(startAt));
        if (StringUtils.isNotBlank(userName)) {
            vo.setUserName(userName.trim());
        }
        if (StringUtils.isNotBlank(orgNameLike)) {
            vo.setOrgNameLike(orgNameLike);
        }
        vo.setAdmin(context.isAdmin());
        Page<PointUserListVO> page = pointUserClients.userRankList(vo);
        Integer pageTotal = 0;
        if (null != page) {
            pageTotal = page.getTotal();
        }
        Map<String, Integer> pageMap = new HashMap<>();
        pageMap.put("pageNo", pageNo);
        pageMap.put("pageSize", pageSize);
        pageMap.put("pageTotal", pageTotal);
        return Response.ok(page, pageMap);
    }

    @ApiOperation(value = "新积分排名列表", notes = "新积分排名列表")
    @GetMapping("/new/rank/list")
    public Response<Page<PointUserListVO>> userRankList(
            @ApiParam(value = "名称类型", required = false) @RequestParam(value = "nameType", required = false) Integer nameType,
            @ApiParam(value = "时间类型", required = false) @RequestParam(value = "dateType", required = false) Integer dateType,
            @ApiParam(value = "当前第几页", required = false) @RequestParam(value = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam(value = "每页信息数 ", required = false) @RequestParam(value = "pageSize", defaultValue = "5") Integer pageSize){
        PointUserParamVO vo = new PointUserParamVO();
        RequestContext context = ContextHolder.get();
        Long companyId = context.getCompanyId();
        vo.setPageNo(pageNo);
        vo.setPageSize(pageSize);
        vo.setSiteId(context.getSiteId());
        vo.setCompanyId(companyId);
        vo.setOrgId(context.getOrgId());
        vo.setAccountId(context.getAccountId());
        vo.setNameType(nameType);
        vo.setDateType(dateType);
        Page<PointUserListVO> page = pointUserClients.newUserRankList(vo);
        return Response.ok(page);
    }

    @ApiOperation(value = "积分排名列表导出", notes = "积分排名列表导出")
    @GetMapping("/rank/list/export")
    public Response<Page<PointUserListVO>> userRankListExport(
            @ApiParam(value = "用户名", required = false) @RequestParam(value = "userName", required = false) String userName,
            @ApiParam(value = "部门关键字", required = false) @RequestParam(value = "orgNameLike", required = false) String orgNameLike,
            @ApiParam(value = "开始时间戳 毫秒值 ", required = false) @RequestParam(value = "startAt",required = false) Long startAt,
            @ApiParam(value = "结束时间戳 毫秒值 ", required = false) @RequestParam(value = "endAt",required = false) Long endAt) {
        Date date = new Date();
        Long taskId = date.getTime();
        String serialNo = "POINT-EXPORT- " + taskId.toString();
        String taskName = "积分排名导出任务-" + taskId.toString();
        Map<String, Object> map = new HashMap<>();
        map.put("serialNo", serialNo);
        map.put("taskId", taskId);
        map.put("taskName", taskName);
        PointUserParamVO vo = new PointUserParamVO();
        RequestContext context = ContextHolder.get();
        vo.setSiteId(context.getSiteId());
        vo.setCompanyId(context.getCompanyId());
        vo.setOrgId(context.getOrgId());
        vo.setAdmin(context.isAdmin());
        vo.setAccountId(context.getAccountId());
        vo.setUserName(userName);
        vo.setOrgNameLike(orgNameLike);
        vo.setEndAt(new Date(endAt));
        vo.setStartAt(new Date(startAt));
        map.put("vo", vo);
        pointUserExport.execute(map, true);
        return Response.ok("任务序号:" + serialNo + ",任务名称:" + taskName);
    }


    @ApiOperation(value = "积分排名列表", notes = "积分排名列表")
    @GetMapping("/detail")
    public Response<PointUserListVO> userDetail(
            @ApiParam(value = "变动类型", required = false) @RequestParam(value = "changeType", required = false) Integer changeType,
            @ApiParam(value = "用户名", required = false) @RequestParam(value = "accountId", required = false) Long accountId,
            @ApiParam(value = "当前第几页", required = false) @RequestParam(value = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam(value = "每页信息数 ", required = false) @RequestParam(value = "pageSize", defaultValue = "20") Integer pageSize,
            @ApiParam(value = "开始时间戳 毫秒值 ", required = false) @RequestParam(value = "startAt",required = false) Long startAt,
            @ApiParam(value = "结束时间戳 毫秒值 ", required = false) @RequestParam(value = "endAt",required = false) Long endAt) {
        PointUserParamVO vo = new PointUserParamVO();
        RequestContext context = ContextHolder.get();
        Long companyId = context.getCompanyId();
        vo.setPageNo(pageNo);
        vo.setPageSize(pageSize);
        vo.setSiteId(context.getSiteId());
        vo.setCompanyId(companyId);
        vo.setOrgId(context.getOrgId());
        vo.setAccountId(context.getAccountId());
        vo.setAdmin(context.isAdmin());
        Page<PointUserListVO> page = pointUserClients.userRankList(vo);
        Integer pageTotal = 0;
        if (null != page) {
            pageTotal = page.getTotal();
        }
        Map<String, Integer> pageMap = new HashMap<>();
        pageMap.put("pageNo", pageNo);
        pageMap.put("pageSize", pageSize);
        pageMap.put("pageTotal", pageTotal);
        return Response.ok(page, pageMap);
    }

    @ApiOperation(value = "用户的积分分页列表", notes = "用户的积分分页列表", response = PointProductVo.class)
    @GetMapping("/list")
    //public Response<Page<PointUserPageListVO>> list(@RequestBody PointSearchParamVO searchParamVO){
    public Response<Page<PointUserPageListVO>> list(@RequestParam(value = "pageNo", required = false) int pageNo,
                                                    @RequestParam(value = "pageSize", required = false) int pageSize,
                                                    @RequestParam(value = "name", required = false) String name){
        PointSearchParamVO searchParamVO = new PointSearchParamVO();
        searchParamVO.setName(name);
        searchParamVO.setPageNo(pageNo);
        searchParamVO.setPageSize(pageSize);
        try {
            return Response.ok(pointUserClients.list(searchParamVO));
        } catch (Exception e) {
            LOG.error("服务出错。", e);
            return Response.fail();
        }
    }

    @ApiOperation(value = "用户积分兑换", notes = "用户积分兑换", response = PointProductVo.class)
    @PostMapping("/exchange")
    public Response<Object> exchange(@RequestBody PointUserExchangeVO pointUserExchangeVO){
        if(pointUserExchangeVO.getPoint() <= 0) {
            return Response.fail("兑换积分必须大于0");
        }
        int ret = pointUserClients.exchange(pointUserExchangeVO);
        if(ret > 0) {
            return Response.ok();
        } else {
            return Response.fail("积分扣减失败,余额不足");
        }
    }

}
