package com.yizhi.application.portal.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.site.application.feign.TrSiteStudentFeignClients;
import com.yizhi.site.application.vo.site.TrSitePageVO;
import com.yizhi.site.application.vo.site.TrSiteStudentParamsVo;
import com.yizhi.site.application.vo.site.TrSiteStudentVo;
import com.yizhi.system.application.system.remote.SiteClient;
import com.yizhi.system.application.vo.SiteVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 站点管理
 *
 * @author lly
 * @Date: 2018/3/17 20:30
 */

@Api(tags = "管理端专区配置")
@RestController
@RequestMapping("/manage/site/student/")
public class TrSiteStudentController {
    @Autowired
    private TrSiteStudentFeignClients trSiteStudentFeignClients;
    @Autowired
    private SiteClient remoteSiteClient;
    @Autowired
    private RedisCache redisCache;

    /**
     * 保存配置的站点
     *
     * @param vos
     * @return
     */
    @PostMapping("/save")
    @ApiOperation(value = "保存配置的站点", response = TrSiteStudentVo.class)
    public Response save(@ApiParam("vos") @RequestBody List<TrSiteStudentVo> vos) {
        if (vos.get(0).getStudentSiteId() == null) {
            return Response.fail("studentSiteId必传！");
        }
        Integer save = trSiteStudentFeignClients.save(vos);
        if (save != 1) {
            return Response.fail("操作失败！");
        }
        String key = CacheNamespace.SITE_STUDENT_RECORDS + ContextHolder.get().getSiteId();
        redisCache.delete(key);
        return Response.ok("操作成功！");

    }

    /**
     * 查询配置的列表
     *
     * @param trSitePageVO
     * @return
     */
    @PostMapping("/getPage")
    @ApiOperation(value = "查询配置的列表", response = TrSiteStudentVo.class)
    public Response getPage(@ApiParam("trSitePageVO") @RequestBody TrSitePageVO trSitePageVO) {
        Page<TrSiteStudentVo> page = trSiteStudentFeignClients.getPage(trSitePageVO);
        List<TrSiteStudentVo> records = page.getRecords();

        if (CollectionUtils.isNotEmpty(records)) {
            //获取实时数据
            List<Long> collect = records.parallelStream().map(a -> a.getStudentSiteId()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                List<SiteVO> siteVOS = remoteSiteClient.selectByIds(collect);
                if (CollectionUtils.isNotEmpty(siteVOS)) {
                    Map<Long, SiteVO> siteVOMap = siteVOS.parallelStream().collect(Collectors.toMap(SiteVO::getId, a -> a));
                    records.forEach(a -> {
                        if (siteVOMap != null) {
                            SiteVO siteVO = siteVOMap.get(a.getStudentSiteId());
                            if (siteVO != null) {
                                a.setCode(siteVO.getCode());
                                a.setEnabled(siteVO.getEnabled() ? 1 : 0);
                                a.setLogo(siteVO.getLogo());
                                a.setSiteName(siteVO.getName());
                            }
                        }
                    });
                }
            }
        }
        return Response.ok(page);
    }

    /**
     * 删除已配置的数据
     *
     * @param trSiteStudentVo
     * @return
     */
    @PostMapping("/remove")
    @ApiOperation(value = "删除已配置的数据", response = TrSiteStudentVo.class)
    public Response remove(@ApiParam("trSitePageVO") @RequestBody TrSiteStudentVo trSiteStudentVo) {
        if (trSiteStudentVo.getId() == null) {
            return Response.fail("Id必传！！！");
        }

        Integer remove = trSiteStudentFeignClients.remove(trSiteStudentVo.getId());
        if (remove == 1) {
            String key = CacheNamespace.SITE_STUDENT_RECORDS + ContextHolder.get().getSiteId();
            redisCache.delete(key);
            return Response.ok("操作成功！");
        }
        return Response.fail("操作失败！");
    }

    /**
     * 上移下移
     *
     * @param paramsVo
     * @return
     */
    @PostMapping("/move")
    @ApiOperation(value = "上移下移")
    public Response move(@ApiParam("paramsVo") @RequestBody TrSiteStudentParamsVo paramsVo) {
        if (paramsVo.getId() == null || paramsVo.getMoveUp() == null) {
            return Response.fail("缺少必传参数！！！");
        }
        TrSiteStudentParamsVo result = trSiteStudentFeignClients.move(paramsVo);
        if (result.getSuccess()) {
            String key = CacheNamespace.SITE_STUDENT_RECORDS + ContextHolder.get().getSiteId();
            redisCache.delete(key);
            return Response.ok();
        } else {
            return Response.fail(result.getErrorMsg());
        }
    }
}
