/**
 * 
 */
package com.yizhi.core.application.context;

import java.util.Date;
import java.util.List;

import com.yizhi.core.application.vo.AuthorizeVO;
import com.yizhi.core.application.vo.AuthorizeChapterVO;
import lombok.Data;

/**
 * @author scotthu
 *
 * @date 2018年3月20日
 */
@Data
public class TaskContext {
	
	/**
	 * 任务标识
	 */
	Long taskId;
	
	/**
	 * 任务编号
	 */
	String serialNo;
	
	/**
	 * 任务名称
	 */
	String taskName;
	/**
	 * 任务提交人id
	 */
	Long submitterId;
	
	/**
	 * 任务提交时间
	 */
	Date submitTime;
	
	Long siteId;
	/**
	 * 公司id
	 */
	Long companyId;

    AuthorizeVO authorizeVO;

    AuthorizeChapterVO chapterVO;

    RequestContext context;

    List<String> ids;
	
	
	public TaskContext(Long taskId,String taskName,Long submitterId,Date submitTime) {
		this.taskId = taskId;
		this.taskName = taskName;
		this.submitterId = submitterId;
		this.submitTime = submitTime;
	}


	public TaskContext(Long taskId, String taskName, Long submitterId, Date submitTime, Long siteId, Long companyId) {
		super();
		this.taskId = taskId;
		this.taskName = taskName;
		this.submitterId = submitterId;
		this.submitTime = submitTime;
		this.siteId = siteId;
		this.companyId = companyId;
	}
	
	public TaskContext(Long taskId,String serialNo, String taskName, Long submitterId, Date submitTime, Long siteId, Long companyId) {
		super();
		this.taskId = taskId;
		this.serialNo = serialNo;
		this.taskName = taskName;
		this.submitterId = submitterId;
		this.submitTime = submitTime;
		this.siteId = siteId;
		this.companyId = companyId;
	}

    public TaskContext(Long taskId, String serialNo, String taskName, Long submitterId, Date submitTime, Long siteId, Long companyId, AuthorizeVO authorizeVO, RequestContext context
    ) {
        super();
        this.taskId = taskId;
        this.serialNo = serialNo;
        this.taskName = taskName;
        this.submitterId = submitterId;
        this.submitTime = submitTime;
        this.siteId = siteId;
        this.companyId = companyId;
        this.authorizeVO = authorizeVO;
        this.context = context;
    }

    public TaskContext(Long taskId, String serialNo, String taskName, Long submitterId, Date submitTime, AuthorizeChapterVO chapterVO, List<String> ids) {
        super();
        this.taskId = taskId;
        this.serialNo = serialNo;
        this.taskName = taskName;
        this.submitterId = submitterId;
        this.submitTime = submitTime;
        this.chapterVO = chapterVO;
        this.ids = ids;
    }
}
