package com.yizhi.core.application.exception;

public class CloudBaseException extends RuntimeException{
	
	private static final long serialVersionUID = 2926203406490559494L;
	
	public static final int UNKNOWN_EXCEPTION = 0;
    public static final int BIZ_EXCEPTION = 1;
    public static final int TIMEOUT_EXCEPTION = 2;
    public static final int FORBIDDEN_EXCEPTION = 3;

    private int typecode = BIZ_EXCEPTION;
    protected String errCode;

    public CloudBaseException() {
        super();
    }

    public CloudBaseException(String message, Throwable cause) {
        super(message, cause);
    }

    public CloudBaseException(String message) {
        super(message);
    }

    public CloudBaseException(Throwable cause) {
        super(cause);
    }


    public CloudBaseException(int type, String errCode) {
        super();
        this.typecode = type;
        this.errCode = errCode;
    }

    public CloudBaseException(int type, String errCode, String message, Throwable cause) {
        super(message, cause);
        this.typecode = type;
        this.errCode = errCode;
    }

    public CloudBaseException(int type, String errCode, String message) {
        super(message);
        this.typecode = type;
        this.errCode = errCode;
    }

    public CloudBaseException(int type, String errCode, Throwable cause) {
        super(cause);
        this.typecode = type;
        this.errCode = errCode;
    }

	public String getErrCode() {
		return errCode;
	}
}
