package com.yizhi.core.application.exception;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.yizhi.util.application.constant.ReturnCode;

/**
 * 资源已存在异常
 * @author scotthu
 */
@ResponseStatus(HttpStatus.NOT_FOUND)
public class ResourceExistException extends RuntimeException{

	private static final long serialVersionUID = 2813349230951445006L;
	
	public ResourceExistException() {
		super(ReturnCode.RESOURCE_EXIST.toString());
	}
}
