package com.yizhi.core.application.exception;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.yizhi.util.application.constant.ReturnCode;

/**
 * 资源没找到或不存在异常
 * @author scotthu
 */
@ResponseStatus(HttpStatus.NOT_FOUND)
public class ResourceNotFoundException extends RuntimeException{
	
	private static final long serialVersionUID = -5541549572806153517L;
	
	public ResourceNotFoundException() {
		super(ReturnCode.RESOURCE_NOT_FOUND.toString());
	}

}
