package com.yizhi.core.application.file.exp;

import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import com.yizhi.core.application.enums.FileType;
import com.yizhi.core.application.file.domain.FileInfo;
import com.yizhi.core.application.file.domain.Template;
import com.yizhi.core.application.task.AbstractTaskHandler;

/**
 * 文件导出抽象类
 * @author Administrator
 *
 */
public abstract class AbstractExporter<T> extends AbstractTaskHandler {
	
	protected HttpServletResponse response;
	protected Template template;
	protected List<T> data;
	
	public AbstractExporter(HttpServletResponse response,Template template,List<T> data) {
		this.response = response;
		this.template = template;
		this.data = data;
	}
	
	public AbstractExporter(Template template,List<T> data) {
		this.template = template;
		this.data = data;
	}
	/**
	 * 工厂类方法，封装导出类的创建细节
	 * @param fileType
	 * @return
	 */
	public static <T>  AbstractExporter<T> build(FileType fileType, HttpServletResponse response, Template template, List<T> data){
		AbstractExporter<T> exporter;
		switch (fileType){ 
		case CSV:
			exporter = new CsvExportor<T>(response,template, data);
			break;
		case PDF:
			exporter = new PdfExportor<T>(response,template, data);
			break;
		default:
			exporter = new ExcelExportor<T>(response,template, data);
			break;			
		}
		return exporter;
	}
	
	/**
	 * 工厂类方法，封装导出类的创建细节
	 * @param fileType
	 * @return
	 */
	public static <T>  AbstractExporter<T> build(FileType fileType,Template template,List<T> data){
		AbstractExporter<T> exporter;
		switch (fileType){ 
		case CSV:
			exporter = new CsvExportor<T>(template, data);
			break;
		case PDF:
			exporter = new PdfExportor<T>(template, data);
			break;
		default:
			exporter = new ExcelExportor<T>(template, data);
			break;			
		}
		return exporter;
	}
	/**
	 * 工厂方法，封装创建到处类细节
	 * @param fileType
	 * @param template
	 * @param data
	 * @return
	 */
	public static <T>  AbstractExporter<T> build(String fileType,Template template,List<T> data){
		AbstractExporter<T> exporter;
		switch (fileType){ 
		case "csv":
			exporter = new CsvExportor<T>(template, data);
			break;
		case "pdf":
			exporter = new PdfExportor<T>(template, data);
			break;
		default:
			exporter = new ExcelExportor<T>(template, data);
			break;			
		}
		return exporter;
	}
	
	/**
	 * 工厂方法，封装创建到处类细节
	 * @param fileType
	 * @param response
	 * @param template
	 * @param data
	 * @return
	 */
	public static <T>  AbstractExporter<T> build(String fileType,HttpServletResponse response,Template template,List<T> data){
		AbstractExporter<T> exporter;
		switch (fileType){ 
		case "csv":
			exporter = new CsvExportor<T>(response,template, data);
			break;
		case "pdf":
			exporter = new PdfExportor<T>(response,template, data);
			break;
		default:
			exporter = new ExcelExportor<T>(response,template, data);
			break;			
		}
		return exporter;
	}
	/**
	 * 导出文件模板方法
	 * @throws IOException 
	 */
	public void handle(){
		render();
   }
	/**
	 * 执行导出操作,有返回值
	 * @return
	 */
	public FileInfo export(){
		return render();
   }
	/**
	 * 渲染，根据导出的文件类型，选择导出文件的模板
	 * @param response
	 * @param template
	 * @param data
	 * @return
	 * @throws IOException
	 */
	public abstract FileInfo render();
}
