
package com.yizhi.core.application.file.exp;

import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.domain.FileInfo;
import com.yizhi.core.application.file.domain.Template;
import com.yizhi.core.application.file.domain.TemplateColumn;
import com.yizhi.core.application.file.util.OssUpload;
import com.yizhi.core.application.log.TaskLogEvent;
import com.yizhi.util.application.clazz.ClassUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;


/**
 * Excel导出模板实现类
 *
 * @author yinyuyan 2018/01/23
 */
public class ExcelExportor<T> extends AbstractExporter<T> {
    private static final Logger logger = LoggerFactory.getLogger(ExcelExportor.class);

    private String httpProxyUrl;
    private Integer httpProxyPort;

    public ExcelExportor(HttpServletResponse response, Template template, List<T> data) {
        super(response, template, data);
    }

    public ExcelExportor(Template template, List<T> data) {
        super(template, data);
    }

    public ExcelExportor(HttpServletResponse response, Template template, List<T> data, String httpProxyUrl, Integer httpProxyPort) {
        super(response, template, data);
        this.httpProxyUrl = httpProxyUrl;
        this.httpProxyPort = httpProxyPort;
    }

    public ExcelExportor(Template template, List<T> data, String httpProxyUrl, Integer httpProxyPort) {
        super(template, data);
        this.httpProxyUrl = httpProxyUrl;
        this.httpProxyPort = httpProxyPort;
    }

    @Override
    public FileInfo render() {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileType(template.getFileType());
        //创建HSSFWorkbook对象(excel的文档对象)
        HSSFWorkbook wb = new HSSFWorkbook();
        //建立新的sheet对象（excel的表单）
        HSSFSheet sheet = wb.createSheet();
        //在sheet里创建第一行，标题行
        HSSFRow row1 = sheet.createRow((int) 0);
        //标题目录
        List<TemplateColumn> columns = template.getColumns();
        for (int i = 0; i < columns.size(); i++) {
            Cell cell = row1.createCell(i);
            String columnName = columns.get(i).getColumnName();
            if (i == 0) {
                HSSFFont redFont = (HSSFFont) wb.createFont();
                redFont.setColor(HSSFColor.RED.index);//
                HSSFRichTextString richString = new HSSFRichTextString("用户名(必填项)");
                //给必填项设置为红色
                richString.applyFont(3, 7, redFont);
                cell.setCellValue(richString);
            } else {
                cell.setCellValue(columnName.toString());
            }
        }
        //行数据
        HSSFRow row2 = null;
        int passCount = 0;
        int failCount = 0;
        if (CollectionUtils.isNotEmpty(data)) {
            for (int j = 0; j < data.size(); j++) {
                T t = data.get(j);
                row2 = sheet.createRow((int) j + 1);
                for (int m = 0; m < columns.size(); m++) {
                    TemplateColumn templateColumn = columns.get(m);
                    String cellValue = ClassUtil.invokeMethod(t, templateColumn.getColumn()).toString();
//		    		 if("result".equals(templateColumn.getColumn())){
//		    			 if(StringUtils.isNotEmpty(cellValue)){
//		    				 failCount++;
//		    			 }else{
//		    				 passCount++;
//		    			 }
//		    		 }
                    row2.createCell(m).setCellValue(cellValue);
                }
                passCount++;
            }
        }
        String fileName = template.getFileName();
        if (StringUtils.isEmpty(fileName)) {
            fileName = "导出文件".concat(String.valueOf(System.currentTimeMillis())).concat(".xls");
        }
        fileInfo.setFileName(fileName);
        if (template.getBrowserExport()) {
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.setContentType("application/vnd.ms-excel");
            OutputStream output = null;
            try {
                output = response.getOutputStream();
                wb.write(output);
                output.flush();
                publishTaskEvent(TaskLogEvent.success(taskContext, "导出成功", null));
            } catch (IOException e) {
                publishTaskEvent(TaskLogEvent.fail(taskContext, "文件导出异常:" + e.getMessage()));
                logger.error("文件导出异常", e);
            } finally {
                try {
                    output.close();
                } catch (IOException e) {
                    logger.error("文件导出关闭流异常", e);
                }
            }
        } else {
//            String path = new StringBuffer().append("E\\").append(File.separator).append(fileName).toString();
            String path = new StringBuffer().append(FileConstant.SAVE_PATH).append(File.separator).append(fileName).toString();
//	    	//文件保存位置
            File saveDir = new File(FileConstant.SAVE_PATH);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
//            File file = new File(saveDir+File.separator+fileName);
            File file = new File(path);

            try {
                FileOutputStream os = new FileOutputStream(file);
                wb.write(os);
                os.close();
                //阿里云返回url
                String upLoadUrl = null;
                if (!StringUtils.isBlank(httpProxyUrl) && httpProxyPort != null && httpProxyPort != 0) {
                    upLoadUrl = OssUpload.upload(path, fileName, httpProxyUrl, httpProxyPort);//path, fileName
                } else {
                    upLoadUrl = OssUpload.upload(path, fileName);//path, fileName
                }
                publishTaskEvent(TaskLogEvent.success(taskContext, "成功导出" + passCount + "条，导入失败" + failCount + "条", upLoadUrl));
                file.delete();
            } catch (Exception e) {
                publishTaskEvent(TaskLogEvent.fail(taskContext, "写入过程中发生错误:" + e.getMessage()));
                logger.error("写入过程中发生错误", e);
            }
        }
        return fileInfo;
    }
}
