package com.yizhi.core.application.file.imp;

import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

import com.yizhi.core.application.file.domain.FileInfo;
import com.yizhi.core.application.file.domain.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import au.com.bytecode.opencsv.CSVReader;

public class CsvImporter extends AbstractImporter {
	
	private static final Logger logger = LoggerFactory.getLogger(CsvImporter.class);

	public <T> CsvImporter(String fileUrl, String fileName, String savePath, ImportCallBack callBack, Template template, Class<T> domainClazz){
		super(fileUrl,savePath,fileName,callBack,template,domainClazz);
	}
	
	@Override
	protected List<String[]> parse(FileInfo fileInfo, Template template) {
		List<String[]> lines;
		CSVReader csvReader = null;
		
		try {
			csvReader = new CSVReader(new FileReader(fileInfo.getFileName()));
			lines = csvReader.readAll();
		} catch (Exception e) {
			logger.error("文件读取过程中出错:",e);
//    		publishTaskEvent(TaskLogEvent.fail(taskContext,"csv文件读取过程中出错,确保导入文件内容格式和模板一致"));
			throw new RuntimeException("文件读取过程中出错:" + e.getMessage());
		}finally {
			if(csvReader != null) {
				try {
					csvReader.close(); 
				} catch (Exception e2) {
//					publishTaskEvent(TaskLogEvent.fail(taskContext,"csv关闭文件读入器出错,确保导入文件内容格式和模板一致"));
					logger.error("关闭文件读入器出错:" + e2.getMessage());
				}
			}
		}
		
		return lines;
	}

	@Override
	protected List<String[]> parse(InputStream inputStream, Template template) {
		List<String[]> lines;
		CSVReader csvReader = null;
		
		try {
			csvReader = new CSVReader(new InputStreamReader(inputStream));
			lines = csvReader.readAll();
		} catch (Exception e) {
			logger.error("文件读取过程中出错:",e);
//    		publishTaskEvent(TaskLogEvent.fail(taskContext,"csv文件读取过程中出错"));
			throw new RuntimeException("文件读取过程中出错:" + e.getMessage());
		}finally {
			if(csvReader != null) {
				try {
					csvReader.close(); 
				} catch (Exception e2) {
//					publishTaskEvent(TaskLogEvent.fail(taskContext,"csv关闭文件读入器出错"));
					logger.error("关闭文件读入器出错:" + e2.getMessage());
				}
			}
		}
		
		return lines;
	}
	
}
