package com.yizhi.core.application.file.imp;

import com.alibaba.fastjson.JSON;
import com.yizhi.core.application.file.domain.FileInfo;
import com.yizhi.core.application.file.domain.Template;
import org.apache.poi.ss.usermodel.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

/**
 * Excel文件导入类
 * 
 * @author scotthu
 *
 * @date 2018年1月30日
 */
public class ExcelImporter extends AbstractImporter {

	private static final Logger logger = LoggerFactory.getLogger(ExcelImporter.class);

	public ExcelImporter(String fileUrl, String fileName, String savePath, ImportCallBack callBack, Template template,
			Class domainClazz) {
		super(fileUrl, savePath, fileName, callBack, template, domainClazz);
	}


	@Override
	protected List<String[]> parse(FileInfo fileInfo, Template template) {
		List<String> errors = new ArrayList<>();
		int columnCount = template.getColumns().size();

		Workbook book = null;
		try {
			File file = new File(savePath+File.separator+fileName);
			logger.info("parse file ======"+JSON.toJSONString(file));
			book = WorkbookFactory.create(new FileInputStream(file));
		} catch (Exception e) {
			logger.error("excel文件读取发生错误",e);
//    		publishTaskEvent(TaskLogEvent.fail(taskContext,"excel文件读取发生错误"));
    		throw new RuntimeException("excel文件读取发生错误");
		}
		
		List<String[]> lines = new ArrayList<>(); 
		Sheet sheet = book.getSheetAt(0);
		for (int i = template.getStartLine() - 1; i <= sheet.getLastRowNum(); i++) {
			Row row = sheet.getRow(i);
			String[] result = new String[columnCount];
				for (int j = 0; j < row.getLastCellNum(); j++) {
					try {
						Cell cell = row.getCell(j);
						String cellValue="";
						if(cell!=null){
							cell.setCellType(Cell.CELL_TYPE_STRING);
							cellValue=cell.getStringCellValue();
						}						
						result[j] = cellValue;
						
					} catch (Exception e) {
						logger.error("错误发生在第：" + (i + 1) + "行" + "第" + (j + 1) + "列",e);
						errors.add("错误发生在第：" + (i + 1) + "行" + "第" + (j + 1) + "列");
					}
					
				}
				lines.add(result);
		}
		
		if(errors.size()>0) {
//    		publishTaskEvent(TaskLogEvent.fail(taskContext,"excel解析文件数据错误"));
			throw new RuntimeException(errors.toString());
		}

		return lines;
	}


	@Override
	protected List<String[]> parse(InputStream inputStream, Template template) {
		List<String> errors = new ArrayList<>();
		int columnCount = template.getColumns().size();

		Workbook book = null;
		try {
			book = WorkbookFactory.create(inputStream);
		} catch (Exception e) {
			logger.error("excel文件读取发生错误",e);
//    		publishTaskEvent(TaskLogEvent.fail(taskContext,"excel文件读取发生错误"));
    		throw new RuntimeException("excel文件读取发生错误");
		}
		
		List<String[]> lines = new ArrayList<>(); 
		Sheet sheet = book.getSheetAt(0);
		DecimalFormat df = new DecimalFormat("0");
		for (int i = template.getStartLine() - 1; i <= sheet.getLastRowNum(); i++) {
			Row row = sheet.getRow(i);
			String[] result = new String[columnCount];
				for (int j = 0; j < row.getLastCellNum(); j++) {
					try {
						Cell cell = row.getCell(j);
						String cellValue = "";
						if (cell != null) {
							if (cell.getCellType() == Cell.CELL_TYPE_NUMERIC) {
								cell.setCellType(cell.CELL_TYPE_STRING);
								logger.info("读取的cell:"+cellValue);
								cellValue = String.valueOf(cell);
                                if (String.valueOf(cell).indexOf("E") != -1 || String.valueOf(cell).indexOf("e") != -1) {
									logger.info("读取的科学计数法cell:"+cellValue);
                                    cellValue = df.format(cell.getNumericCellValue());
                                }
							} else {
								cell.setCellType(Cell.CELL_TYPE_STRING);
								cellValue = cell.getStringCellValue();
							}
						}
						logger.info("最后读取的cell:"+cellValue);
						result[j] = cellValue;
						
					} catch (Exception e) {
						logger.error("错误发生在第：" + (i + 1) + "行" + "第" + (j + 1) + "列",e);
						errors.add("错误发生在第：" + (i + 1) + "行" + "第" + (j + 1) + "列");
					}
					
				}
				lines.add(result);
		}
		
		if(errors.size()>0) {
//    		publishTaskEvent(TaskLogEvent.fail(taskContext,"excel解析文件数据错误,确保导入文件内容格式和模板一致"));
			throw new RuntimeException(errors.toString());
		}

		return lines;
	}

	public static void main(String[] args) {
		Double a =  1.3471022771E10;

		double b = 1.22;
		DecimalFormat df = new DecimalFormat("0");
         a = b;
		System.out.println(a.toString()+"----------");
		if (a.toString().indexOf("E") != -1){
			System.out.println(df.format(a));
		}else {
			System.out.println(a);
		}



	}
}
