package com.yizhi.core.application.file.util;

import com.yizhi.util.application.spring.SpringUtil;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;

/**
 * @author wenjunlong
 */
public class OssUpload {

    private static String bucketName = "upload";

    /**
     * 上传文件到阿里云
     *
     * @param uploadFile 上传文件完整路径(/test.xls)
     * @param key        上传到阿里云的文件名带后缀名(testaliyun.xls)
     * @return
     */
    public static String upload(String uploadFile, String key) {
        return upload(uploadFile, key, null, null);
    }

    /**
     * 上传文件到阿里云，支持代理
     *
     * @param uploadFile 上传文件完整路径(/test.xls)
     * @param key        上传到阿里云的文件名带后缀名(testaliyun.xls)
     * @return
     */
    public static String upload(String uploadFile, String key, String proxyUrl, Integer proxyPort) {
        MinioTools minioTools = SpringUtil.getBean(MinioTools.class);
        try {
            minioTools.uplodFile(bucketName,key,new FileInputStream(uploadFile));
            return minioTools.getFile(bucketName,key);
        } catch (Exception oe) {
            return "error";
        }

    }

    /**
     * 上传文件到oss，上传成功返回url地址，复制返回空字符串
     *
     * @param data
     * @param filename
     * @return url有效期为2年
     */
    public static String upload(byte[] data, String filename) {
        String ret = "";
        MinioTools minioTools = SpringUtil.getBean(MinioTools.class);
        try {
            minioTools.uplodFile(bucketName,filename,new ByteArrayInputStream(data));
            ret = minioTools.getFile(bucketName,filename);
        } catch (Exception e) {
            ret = e.getMessage();
        }
        return ret;
    }
}
