package com.yizhi.core.application.file.util;

import java.net.InetSocketAddress;
import java.net.Proxy;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 代理服务器创建类
 * @author mei
 *
 */


public class ProxyCreateUtil { 
	private Integer httpProxyPort;
	 
	private String httpProxyUrl;
	
	private static final Logger logger = LoggerFactory.getLogger(ProxyCreateUtil.class);
	
	public Proxy createUrlProxy(){
		Proxy proxy = createUrlProxy(httpProxyUrl, httpProxyPort);
		
        return proxy;
	}
	
	public static Proxy createUrlProxy(String proxyUrl, Integer proxyPort){
		
		logger.info("设置代理 course :httpProxyUrl={}  httpProxyPort={}", proxyUrl, proxyPort);
		
		Proxy proxy = null;
		if(!StringUtils.isBlank(proxyUrl) && proxyPort != null && proxyPort != 0){
			InetSocketAddress addr = new InetSocketAddress(proxyUrl, proxyPort);  
	        proxy = new Proxy(Proxy.Type.HTTP, addr);
		}
		
        return proxy;
	}
}
