/**
 * 
 */
package com.yizhi.core.application.file.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.poi.ss.formula.functions.T;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yizhi.core.application.file.domain.TemplateColumn;

/**
 * 模板信息校验
 * @author scotthu
 *
 * @date 2018年3月23日
 */
public class TemplateUtil {
	
	private TemplateUtil() {
		
	}
	
	/**
	 * 检查模板中的列在类中是否存在
	 * @param template 模板信息
	 * @param domainClazz 实体类
	 * @return  错误信息
	 */
	public static List<String> check(List<TemplateColumn> columns,Class domainClazz) {
		List<String> result = new ArrayList<>();
		if(columns==null || columns.size() ==0) {
			result.add("模板列信息不存在");
			return result;
		}
		
		Field field = null;
		for (TemplateColumn column : columns) {
			try {
				field = domainClazz.getDeclaredField(column.getColumn());
				if(field == null){
					result.add("类中不存在此列：" + column.getColumnName() + ",请检查拼写");
				}
			} catch (Exception e) {
			}
			
			
		}
		return result;
	}
	
	
	/**
	 * 检查模板中的列在类中是否存在
	 * @param template 模板信息
	 * @param domainClazz 实体类
	 * @return  错误信息
	 */
	public static Object convert(List<TemplateColumn> columns,String[] strData,Class domainClazz) {
		ObjectMapper om = new ObjectMapper();
		Map<String,String> mapData = new HashMap<>();
		for (int i = 0; i < strData.length; i++) {
			mapData.put(columns.get(i).getColumn(), strData[i]);
		}
		
		Object data = null; 
		try {
			String convertStr = om.writeValueAsString(mapData);
			data = om.readValue(convertStr, domainClazz);
		} catch (Exception e) {
			throw new RuntimeException("数据转换为对象失败",e);
		}
		
		return data;
		
	}
	/**
	 * 检查模板中的列在类中是否存在
	 * @param template 模板信息
	 * @param domainClazz 实体类
	 * @return  错误信息
	 */
	public static  List convert(List<TemplateColumn> columns,List<String[]> lines,Class<T> domainClazz) {
		List dataObjs = new ArrayList(lines.size()*2);
		 for (String[] line : lines) {
			 if(line.length>0){
				 dataObjs.add(convert(columns, line, domainClazz)); 
			 }			 
		}
		
		 return dataObjs;
	}
	

}
