package com.yizhi.core.application.json;

import java.io.IOException;
import java.lang.reflect.Type;

import com.yizhi.util.application.domain.BizResponse;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.yizhi.util.application.domain.Response;

/**
 * @author scotthu
 *
 * @date 2018年4月11日
 */
public class CloudJackson2HttpMessageConverter extends MappingJackson2HttpMessageConverter{

	private static ObjectMapper responseObjectMapper;
	static {
		responseObjectMapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule();  
        simpleModule.addSerializer(Long.class, ToStringSerializer.instance);  
        simpleModule.addSerializer(Long.TYPE, ToStringSerializer.instance);  
        responseObjectMapper.registerModule(simpleModule);
		//responseObjectMapper.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));//格式化设置
		//responseObjectMapper.setTimeZone(TimeZone.getTimeZone("GMT+8")); 时区设置
        responseObjectMapper.getSerializerProvider().setNullValueSerializer(CloudSimpleNullSerializer.instance);
        responseObjectMapper.setSerializerFactory(responseObjectMapper.getSerializerFactory().withSerializerModifier(new CloudSerializeModifier()));
	}
	/**
	 * @param objectMapper
	 */
	protected CloudJackson2HttpMessageConverter(ObjectMapper objectMapper) {
		super(objectMapper);
	}
	
	@Override
	protected void writeInternal(Object object, Type type, HttpOutputMessage outputMessage)
			throws IOException, HttpMessageNotWritableException {

		JavaType javaType = null;
		if (type != null) {
			javaType = getJavaType(type, null);
		}
		
		if(javaType!=null && (object instanceof Response  || object instanceof BizResponse)) {
			writeResponse(object,outputMessage);
		}else {
			super.writeInternal(object, javaType, outputMessage);
		}
	}
	
	private void writeResponse(Object object, HttpOutputMessage outputMessage)
			throws IOException, HttpMessageNotWritableException {
		
		MediaType contentType = outputMessage.getHeaders().getContentType();
		JsonEncoding encoding = getJsonEncoding(contentType);
		JsonGenerator generator = responseObjectMapper.getFactory().createGenerator(outputMessage.getBody(), encoding);
		try {
			writePrefix(generator, object);
			ObjectWriter objectWriter = responseObjectMapper.writer();
			objectWriter.writeValue(generator, object);
			writeSuffix(generator, object);
			generator.flush();
		}
		catch (JsonProcessingException ex) {
			throw new HttpMessageNotWritableException("Could not write JSON: " + ex.getOriginalMessage(), ex);
		}
	}
	

}
