/**
 *
 */
package com.yizhi.core.application.json;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

/**
 * @author scotthu
 * @date 2018年4月11日
 */
@Configuration
@Order(Integer.MIN_VALUE)
public class CloudJsonConfig {

    @Bean
    public HttpMessageConverters MessageConverts() {
        ObjectMapper commonMapper = new ObjectMapper();
        commonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        CloudJackson2HttpMessageConverter convert = new CloudJackson2HttpMessageConverter(commonMapper);
        return new HttpMessageConverters(convert);
    }

}
