/**
 * 
 */
package com.yizhi.core.application.log;

import java.io.Serializable;
import java.util.Date;

import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.enums.TaskStatus;

import lombok.Data;

/**
 * 任务日志事件
 * @author scotthu
 *
 * @date 2018年3月19日
 */
@Data
public class TaskLogEvent implements Serializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 489476911287542034L;

	/**
	 * 任务标识
	 */
	Long taskId;
	
	/**
	 * 任务编号
	 */
	String serialNo;
	
	/**
	 * 任务名称
	 */
	String taskName;
	/**
	 * 任务提交人id
	 */
	Long submitterId;
	
	/**
	 * 任务状态(1进行中2已完成3执行失败)
	 */
	Integer status;
	/**
	 * 任务结果,如导出文件的链接可以放在这里
	 */
	String result;
	/**
	 * 日志内容
	 */
	String content;
	
	/**
	 * url
	 */
	String url;
	
	/**
	 * 任务提交时间
	 */
	Date submitTime;
	/**
	 * 事件发生时间
	 */
	Date createTime;
	/**
	 * 站点id
	 */
	Long siteId;
	/**
	 * 公司id
	 */
	Long companyId;

	private TaskLogEvent(TaskContext taskContext) {
		this.taskId = taskContext.getTaskId();
		this.taskName = taskContext.getTaskName();
		this.submitterId = taskContext.getSubmitterId();
		this.submitTime = taskContext.getSubmitTime();
		this.createTime = new Date();
		this.siteId = taskContext.getSiteId();
		this.companyId = taskContext.getCompanyId();
		this.serialNo = taskContext.getSerialNo();
	}
	
	private TaskLogEvent(TaskContext taskContext,Integer status) {
		this(taskContext);
		this.status = status;
	}
	
	/**
	 * 工厂方法,创建执行中事件
	 * @param taskContext 任务上下文
	 * @param content 事件内容
	 * @return 任务事件
	 */
	@Deprecated
    public static TaskLogEvent working(TaskContext taskContext,String content) {
    	TaskLogEvent event = new TaskLogEvent(taskContext, TaskStatus.DOING.getCode());
    	event.setContent(content);
    	return event;
    }
	
	/**
	 * 工厂方法,创建执行中事件
	 * @param taskContext 任务上下文
	 * @return 任务事件
	 */
    public static TaskLogEvent working(TaskContext taskContext) {
    	TaskLogEvent event = new TaskLogEvent(taskContext,TaskStatus.DOING.getCode());
    	return event;
    }
    
	/**
	 * 工厂方法,创建执行成功事件
	 * @param taskContext 任务上下文
	 * @param result 任务执行结果
	 * @return 任务事件
	 */
    public static TaskLogEvent success(TaskContext taskContext,String url) {
    	TaskLogEvent event = new TaskLogEvent(taskContext,TaskStatus.DONE.getCode());
    	event.setResult("执行成功");
    	event.setUrl(url);
    	return event;
    }
    /**
     * 工厂方法,创建执行成功事件
     * @param taskContext 任务上下文
     * @param result 任务执行结果
     * @param url 下载url
     * @return 任务事件
     */
    public static TaskLogEvent success(TaskContext taskContext,String result,String url) {
    	TaskLogEvent event = new TaskLogEvent(taskContext,TaskStatus.DONE.getCode());
    	event.setResult(result);
    	event.setUrl(url);
    	return event;
    }
    
	/**
	 * 工厂方法,创建失败事件
	 * @param taskContext 任务上下文
	 * @param content 事件内容
	 * @return 任务事件
	 */
    public static TaskLogEvent fail(TaskContext taskContext,String result) {
    	TaskLogEvent event = new TaskLogEvent(taskContext,TaskStatus.FAIL.getCode());
    	event.setResult(result);
    	return event;
    }


    public static TaskLogEvent success(TaskContext taskContext,String result,Long siteId,Long companyId) {
        TaskLogEvent event = new TaskLogEvent(taskContext,TaskStatus.DONE.getCode());
        event.setResult(result);
        event.setSiteId(siteId);
        event.setCompanyId(companyId);
        return event;
    }

    public static TaskLogEvent fail(TaskContext taskContext,String result,Long siteId,Long companyId) {
        TaskLogEvent event = new TaskLogEvent(taskContext,TaskStatus.FAIL.getCode());
        event.setResult(result);
        return event;
    }
}