package com.yizhi.core.application.mock;

import cn.hutool.core.util.RandomUtil;
import com.forte.util.Mock;
import com.forte.util.mapper.MockArray;
import com.forte.util.mapper.MockValue;
import com.forte.util.mockbean.MockObject;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName MockDemo
 * @Description TODO
 * @Author shengchenglong
 * @DATE 2020/10/22 10:10
 * @Version 1.0
 */
public class MockDemo {

    private static String[] MAIL_SUFFIX = {"163", "sina", "qq", "gmail", "outlook"};


    public static void main(String[] args) {
        // 准备模板载体
        Map<String, Object> template = new HashMap<>(2);
//        //age 是一个 8位 的随机数。
//        template.put("id|1-99999", 0);
//        //name是一个随机的中文名称。
//        template.put("name|1-99999", 0);
//        //email是一个随机的163邮箱。
//        template.put("email|1-99999", 0);
//        //password是一个6-16位数的随机字符。
//        template.put("password|1-99999", 0);

        Class clazz = AccountMockDemo.class;
        Field[] fields = clazz.getDeclaredFields();
        String fieldName = null;
        Object val = 0;
        for (Field field : fields) {
            if (field.isAnnotationPresent(MockArray.class) || field.isAnnotationPresent(MockValue.class)) {
                continue;
            }

            fieldName = field.getName();

            if (fieldName.equals("serialVersionUID")) {
                continue;
            }

            if (field.getType().equals(Date.class)) {
                val = new Date();
                template.put(fieldName, val);
                continue;
            }

            if (field.getType().equals(String.class)) {
                if (fieldName.toLowerCase().contains("mail")) {
                    val = "@email";
                } else {
                    val = "@cname";
                }
                template.put(fieldName, val);
                continue;
            }

            if (field.getType().equals(Boolean.class)) {
                val = RandomUtil.randomBoolean();
                template.put(fieldName, val);
                continue;
            }

        }

        Mock.resetWithOther(AccountMockDemo.class, template);
        MockObject<AccountMockDemo> mockObject = Mock.get(AccountMockDemo.class);
        AccountMockDemo demo = mockObject.getOne();


        List<AccountMockDemo> list = mockObject.getList(20);

        System.out.println(demo);
        System.out.println();
        list.forEach(item -> System.out.println(item));

    }
}
