package com.yizhi.core.application.mock.annotation;

import java.lang.annotation.*;

/**
 * mock 自动装配
 * 注意：1.仅支持 例如：Response<Account> , Response<PageInfo<Account>> , Response<List<Account>>
 *     2.内部非基本类型以及String的属性对象无法装配
 * @author shengchenglong
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface MockAutoResult {

    /**
     * 返回为泛型时的真实返回类型
     *
     * @return
     */
    Class generics() default Object.class;

    String pageNo() default "1";

    String pageSize() default "10";

    boolean isPageable() default false;

    boolean isReturnCollection() default false;
}
