package com.yizhi.core.application.mock.aop;

import cn.hutool.core.util.RandomUtil;
import com.forte.util.Mock;
import com.forte.util.mapper.MockArray;
import com.forte.util.mapper.MockValue;
import com.forte.util.mockbean.MockObject;
import com.yizhi.core.application.mock.annotation.MockAutoResult;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.page.PageInfo;
import lombok.extern.log4j.Log4j2;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Log4j2
@Component
@Aspect
public class MockAutoResultAop {

    @Pointcut("@annotation(com.yizhi.core.application.mock.annotation.MockAutoResult)")
    public void point() {
    }

    @Around(value = "point()")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) {

        MethodSignature methodSignature = (MethodSignature) proceedingJoinPoint.getSignature();

        Method method = methodSignature.getMethod();

        MockAutoResult mockAutoResult = method.getAnnotation(MockAutoResult.class);

        PageInfo pageInfo = null;
        if (mockAutoResult.isPageable()) {
            // spel信息
            String pageNoExpression = mockAutoResult.pageNo();
            String pageSizeExpression = mockAutoResult.pageSize();


            // 分页参数解析
            ExpressionParser parser = new SpelExpressionParser();
            LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
            String[] params = discoverer.getParameterNames(method);

            Object[] args = proceedingJoinPoint.getArgs();

            EvaluationContext context = new StandardEvaluationContext();
            for (int len = 0; len < params.length; len++) {
                context.setVariable(params[len], args[len]);
            }
            Expression expression = parser.parseExpression(pageNoExpression);
            Integer pageNo = expression.getValue(context, Integer.class);

            expression = parser.parseExpression(pageSizeExpression);
            Integer pageSize = expression.getValue(context, Integer.class);
            log.info("MockAutoResultAop -- 分页参数，pageNo：{0}, pageSize：{1}", pageNo, pageSize);

            pageInfo = new PageInfo();
            pageInfo.setPageNo(pageNo == null ? 1 : pageNo);
            pageInfo.setPageSize(pageSize == null ? 10 : pageSize);
            pageInfo.setPageTotal(100);
        }


        // 获取真实返回对象class
        Class clazz = mockAutoResult.generics();
        // 准备模板载体
        Map<String, Object> template = new HashMap<>(2);
        Field[] fields = clazz.getDeclaredFields();
        String fieldName = null;
        Object val = 0;
        Class fieldType = null;
        for (Field field : fields) {
            if (field.isAnnotationPresent(MockArray.class) || field.isAnnotationPresent(MockValue.class)) {
                continue;
            }

            fieldName = field.getName();
            fieldType = field.getType();

            if (fieldName.equals("serialVersionUID")) {
                continue;
            }

            if (fieldType.equals(Date.class)) {
                val = new Date();
                template.put(fieldName, val);
                continue;
            }

            if (fieldType.equals(String.class)) {
                if (fieldName.toLowerCase().contains("mail")) {
                    val = "@email";
                } else {
                    val = "@cname";
                }
                template.put(fieldName, val);
                continue;
            }

            if (fieldType.equals(Integer.class)) {
                template.put(fieldName + "|0-100000", 0);
                continue;
            }

            if (fieldType.equals(Long.class)) {
                template.put(fieldName + "|0-100000000", 0);
                continue;
            }

            if (fieldType.equals(Byte.class) || fieldType.equals(Short.class)) {
                template.put(fieldName + "|0-100", 0);
                continue;
            }

            if (field.getType().equals(Boolean.class)) {
                template.put(fieldName + "|0-1", 0);
                continue;
            }
        }

        Mock.resetWithOther(clazz, template);
        MockObject mockObject = Mock.get(clazz);

        Response response = null;
        if (mockAutoResult.isPageable()) {
            pageInfo.setRecords(mockObject.getList(pageInfo.getPageSize()));
            response = response.withPageInfo(pageInfo);

        } else if (mockAutoResult.isReturnCollection()) {
            response = Response.ok(mockObject.getList(RandomUtil.randomInt(5, 20)));
        } else {
            response = Response.ok(mockObject.getOne());
        }
        return response;
    }

}

