package com.yizhi.core.application.operatelog.intercepter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
 
public class SwaggerInterceptor implements HandlerInterceptor {
 
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (request.getRequestURI().equals("/swagger-ui.html")) {
            response.setStatus(HttpServletResponse.SC_FORBIDDEN);
            return false;  // 拦截访问
        }
        return true;  // 放行其他请求
    }
    
    // 可以实现 postHandle 和 afterCompletion 方法进行相应处理
}