package com.yizhi.core.application.resource;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Author: shengchenglong
 * @Date: 2018/8/31 22:13
 */
@RestController
@RequestMapping("/manage/authz/resource")
public class ScannerController {

    @Autowired
    private ApplicationContext context;

    @Autowired(required = false)
    private AuthzResourceClient authzResourceClient;

    @GetMapping("/scan")
    public List<ScannerResource> scan() {
        RequestContext requestContext = ContextHolder.get();
        if (requestContext.isAdmin()) {
            List<ScannerResource> list = new ArrayList<>();
            Map<String, Object> map = context.getBeansWithAnnotation(Controller.class);
            Map<String, Object> map2 = context.getBeansWithAnnotation(RestController.class);

            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object controller = entry.getValue();

                String controllerMapping = "";
                controllerMapping = controller.getClass().getAnnotation(RequestMapping.class) == null ? "/" : controller.getClass().getAnnotation(RequestMapping.class).value()[0];
                if (!controllerMapping.startsWith("/")) {
                    controllerMapping = "/" + controllerMapping;
                }
                if (controllerMapping.endsWith("/")) {
                    controllerMapping = controllerMapping.substring(0, controllerMapping.length() - 1);
                }

                Method[] methods = controller.getClass().getMethods();
                for (Method method : methods) {
                    ScannerResource operation = new ScannerResource();
                    operation.setControllerName(controller.getClass().getName());
                    operation.setControllerFunction(controller.getClass().getAnnotation(Api.class) == null ? "" : controller.getClass().getAnnotation(Api.class).tags()[0]);

                    String[] requestMappings = null;
                    if (null != method.getAnnotation(RequestMapping.class)) {
                        requestMappings = method.getAnnotation(RequestMapping.class).value();
                    } else if (null != method.getAnnotation(GetMapping.class)) {
                        requestMappings = method.getAnnotation(GetMapping.class).value();
                    } else if (null != method.getAnnotation(PostMapping.class)) {
                        requestMappings = method.getAnnotation(PostMapping.class).value();
                    } else {
                        continue;
                    }

                    for (int i = 0; i < requestMappings.length; i++) {
                        if (!requestMappings[i].startsWith("/")) {
                            requestMappings[i] = "/" + requestMappings[i];
                        }
                        requestMappings[i] = controllerMapping + requestMappings[i];
                    }
                    operation.setRequestMappings(requestMappings);
                    operation.setMethodName(method.getName());
                    operation.setMethodFunction(method.getAnnotation(ApiOperation.class) == null ? "" : method.getAnnotation(ApiOperation.class).value());
                    list.add(operation);
                }
            }

            if (CollectionUtils.isNotEmpty(list)) {
                authzResourceClient.deal(list);
            }

            return list;
        }
        return null;
    }

    /**
     * 涛哥copy
     *
     * @return
     */
    @GetMapping("/new/scan")
    public List<ScannerResource> newScan() {


        List<ScannerResource> list = new ArrayList<>();
        Map<String, Object> map = context.getBeansWithAnnotation(Controller.class);
        Map<String, Object> map2 = context.getBeansWithAnnotation(RestController.class);
        map.putAll(map2);

        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object controller = entry.getValue();

            String controllerMapping = "";
            //RequestMapping annotation = controller.getClass().getAnnotation(RequestMapping.class);
            RequestMapping annotation = AnnotationUtils.findAnnotation(controller.getClass(), RequestMapping.class);
            if (null != annotation && annotation.value().length > 0){
                controllerMapping = annotation.value()[0];
            }
            if (null != annotation && annotation.path().length > 0){
                controllerMapping = annotation.path()[0];
            }
            if (!controllerMapping.startsWith("/")) {
                controllerMapping = "/" + controllerMapping;
            }
            if (controllerMapping.endsWith("/")) {
                controllerMapping = controllerMapping.substring(0, controllerMapping.length() - 1);
            }
            Class<?> userClass = ClassUtils.getUserClass(controller);
            Method[] methods = userClass.getMethods();
            for (Method method : methods) {
                ScannerResource operation = new ScannerResource();
                operation.setControllerName(controller.getClass().getName());
                operation.setControllerFunction(controller.getClass().getAnnotation(Api.class) == null ? "" : controller.getClass().getAnnotation(Api.class).tags()[0]);

                String[] requestMappings = null;
                if (null != method.getAnnotation(RequestMapping.class)) {
                    RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
                    String[] values = requestMapping.value();
                    String[] paths = requestMapping.path();
                    if (null != values && values.length > 0){
                        requestMappings= values;
                    }else if (null != paths && paths.length > 0){
                        requestMappings= paths;
                    }else {
                        continue;
                    }
                } else if (null != method.getAnnotation(GetMapping.class)) {
                    GetMapping mapping = method.getAnnotation(GetMapping.class);
                    String[] values = mapping.value();
                    String[] paths = mapping.path();
                    if (null != values && values.length > 0){
                        requestMappings= values;
                    }else if (null != paths && paths.length > 0){
                        requestMappings= paths;
                    }else {
                        continue;
                    }
                } else if (null != method.getAnnotation(PostMapping.class)) {
                    PostMapping mapping = method.getAnnotation(PostMapping.class);
                    String[] values = mapping.value();
                    String[] paths = mapping.path();
                    if (null != values && values.length > 0){
                        requestMappings= values;
                    }else if (null != paths && paths.length > 0){
                        requestMappings= paths;
                    }else {
                        continue;
                    }
                } else {
                    continue;
                }

                for (int i = 0; i < requestMappings.length; i++) {
                    if (!requestMappings[i].startsWith("/")) {
                        requestMappings[i] = "/" + requestMappings[i];
                    }
                    requestMappings[i] = controllerMapping + requestMappings[i];
                }
                operation.setRequestMappings(requestMappings);
                operation.setMethodName(method.getName());
                operation.setMethodFunction(method.getAnnotation(ApiOperation.class) == null ? "" : method.getAnnotation(ApiOperation.class).value());
                list.add(operation);
            }
        }
        return list;
    }
}

