/**
 *
 */
package com.yizhi.core.application.task;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.util.concurrent.Executor;

/**
 * @author scotthu
 *
 * @date 2018年3月19日
 */
@Component
public class TaskExecutor {

    @Autowired
    @Qualifier("cloudAsync")
    Executor executor;

    /**
     * 将任务提交到线程池异步执行
     * @param handler  任务执行类
     */
    public void asynExecute(AbstractTaskHandler handler) {
        executor.execute(new CloudTask(handler));
    }

}
