package com.yizhi.core.application.token;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import java.security.Key;
import java.util.Date;
import java.util.Map;

public class TokenHelperStatic {

	private TokenConfig config;

	private static Logger logger = LoggerFactory.getLogger(TokenHelperStatic.class);

	public TokenHelperStatic(TokenConfig config){
		this.config = config;
	}

	public String createToken(String subject,Map<String,Object> info) {
		SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
		long nowMillis = System.currentTimeMillis();
		Date now = new Date(nowMillis);
		// 生成签名密钥 就是一个base64加密后的字符串？
		byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary(config.getSeed());
		Key signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
		logger.info("#################%%%%%%%%%%￥￥￥￥￥￥￥￥￥￥："+config.getSeed());
		// 添加构成JWT的参数
		JwtBuilder builder = Jwts.builder().setHeaderParam("type", "JWT").setIssuedAt(now) // 创建时间
				.setSubject(subject) 
				.setIssuer(config.getIssuer()).signWith(signatureAlgorithm, signingKey); // 估计是第三段密钥
		for (String key : info.keySet()) {
			builder.claim(key, info.get(key));
		}
		
		// 添加Token过期时间
		if (config.getTTL() >= 0) {
			// 过期时间
			long expMillis = nowMillis + config.getTTL();
			// 现在是什么时间
			Date exp = new Date(expMillis);
			// 系统时间之前的token都是不可以被承认的
			builder.setExpiration(exp).setNotBefore(now);
		}
		// 生成JWT
		return builder.compact();
	}

	public Claims parseToken(String token) {
		try {
			Claims claims = Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary(config.getSeed()))
					.parseClaimsJws(token).getBody();
			return claims;
		} catch (Exception ex) {
			return null;
		}
	}
}
