package com.yizhi.core.application.vo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * <p>
 * 课程章节
 * </p>
 *
 * @author lilingye
 * @since 2018年10月25日12:49:03
 */
@Data
public class AuthorizeChapterVO {



    @ApiModelProperty(value = "主键id")
    private Long id;

    @ApiModelProperty(value = "章节父id")
    private Long parentId;

    @ApiModelProperty(value = "课程")
    private Long courseId;

    @ApiModelProperty(value = "层级")
    private Integer layer;

    @ApiModelProperty(value = "章节名称")
    private String name;

    @ApiModelProperty(value = "素材id")
    private Long materialId;

    @ApiModelProperty(value = "素材名称")
    private String materialName;

    @ApiModelProperty(value = "素材类型1音频 2 视频 3 文本 4 富媒体 5 Scrom (如果来源类型为3: 测验：1则为测验的01:过程性测验，2则为测验的02:总结性测验)")
    private Integer materialType;

    @ApiModelProperty(value = "可以获得积分")
    private Integer score;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "父子关系排序")
    private String path;

    @ApiModelProperty("来源类型1 素材 2 考试 9: 测验")
    private Integer source;

    @ApiModelProperty(value = "素材编码")
    private String materialCode;

    @ApiModelProperty(value = "复制前章节的id")
    private Long chapterBeforeId;

    @ApiModelProperty(value = "复制标志")
    private Long indexId;


}
