package com.yizhi.application.discovery;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName DiscoveryConfig
 * @Description 灰度发版配置类
 * @Author shengchenglong
 * @DATE 2020/11/20 00:22
 * @Version 1.0
 */
@Component
@ConfigurationProperties(prefix = "rc")
@Getter
@Setter
public class DiscoveryProperties {

    private String nacosServiceListUrl;

    private String nacosInstanceListUrl;

    private Long cacheExpirationSeconds;

    private String cacheName;

    private String rcVersion;

    private String releaseVersion;

    private List<String> companyCodes;

    private Boolean enable;

    private String namespaceId;

}