package com.yizhi.application.discovery;

import com.nepxion.discovery.plugin.strategy.zuul.filter.DefaultZuulStrategyRouteFilter;
import com.netflix.zuul.util.HTTPRequestUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @ClassName MyZuulStrategyRouteFilter
 * @Description 负载均衡前执行路由过滤，组装带上请求版本号
 * @Author shengchenglong
 * @DATE 2020/11/20 14:16
 * @Version 1.0
 */
@Slf4j
public class MyZuulStrategyRouteFilter extends DefaultZuulStrategyRouteFilter {

    private DiscoveryProperties discoveryProperties;

    private ContainerCache containerCache;

    public MyZuulStrategyRouteFilter() {
    }

    public MyZuulStrategyRouteFilter(DiscoveryProperties discoveryProperties, ContainerCache containerCache) {
        this.discoveryProperties = discoveryProperties;
        this.containerCache = containerCache;
    }

    @Override
    public String getRouteVersion() {
        String serviceRouteVersion = discoveryProperties.getReleaseVersion();
        // 如果未开启RC 路由 直接返回 Release
        if (!discoveryProperties.getEnable()) {
            log.info("getRouteVersion -> 未开启 全链路匹配路由，使用 releaseVersion={} 匹配路由", serviceRouteVersion);
            return serviceRouteVersion;
        }

        Map<String, List<String>> queryParams = HTTPRequestUtils.getInstance().getQueryParams();
        if (queryParams == null || CollectionUtils.isEmpty(queryParams.get("companyCode")) || queryParams.get("companyCode").get(0) == null) {
            log.info("getRouteVersion -> 未开启 全链路匹配路由，companyCode=null releaseVersion={} 匹配路由", serviceRouteVersion);
            return serviceRouteVersion;
        }
        String companyCode = queryParams.get("companyCode").get(0);
        Optional<String> companyCodeOptional = discoveryProperties.getCompanyCodes().stream().filter(rcCompanyCode -> rcCompanyCode.equals(companyCode)).findAny();
        // 如果当前企业没有配置 优先访问RC版本的容器，直接返回 Release
        if (!companyCodeOptional.isPresent()) {
            log.info("getRouteVersion -> 当前企业 companyCode={} 未配置全链路匹配路由，使用 releaseVersion={} 匹配路由", companyCode, discoveryProperties.getReleaseVersion());
            return serviceRouteVersion;
        }

        serviceRouteVersion = containerCache.serviceRouteVersion();
        log.info("getRouteVersion -> 当前企业 companyCode={} 执行全链路版本匹配路由={}", companyCode, serviceRouteVersion);
        return serviceRouteVersion;
    }

    @Override
    public int filterOrder() {
        return Integer.MIN_VALUE;
    }
}
