package com.yizhi.application.filter;

import javax.servlet.http.HttpServletResponse;

import cn.hutool.core.date.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;

/***
 * 异常处理
 */
 @Component
public class ErrorFilter extends ZuulFilter {
	Logger logger = LoggerFactory.getLogger(ErrorFilter.class);

	@Override
	public String filterType() {
		return "error";
	}

	@Override
	public int filterOrder() {
		return -1;
	}

	@Override
	public boolean shouldFilter() {
		return true;
	}

	@Override
	public Object run() {
		RequestContext ctx = RequestContext.getCurrentContext();

		Throwable throwable = ctx.getThrowable();
		throwable.printStackTrace();

		ctx.set("error.status_code", HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
		ctx.set("error.exception", throwable.getCause());
		ctx.set("error.message", throwable.getCause().getLocalizedMessage());

		// 打印错误日志
		String url = ctx.getRequest().getRequestURL().toString();
		logger.error("-------------------------------------------------------------------------------------");
		logger.error("请求发生异常, url: {}", url);
		logger.error("请求发生异常, 发生时间: {}", DateTime.now());
		logger.error("请求发生异常, err-msg: {}", throwable.getCause().getLocalizedMessage());
		logger.error("-------------------------------------------------------------------------------------");

		return null;
	}
}
