package com.yizhi.application.filter;

import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.json.JsonMapper;
import com.netflix.zuul.context.RequestContext;
import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

@RestController
@RequestMapping("/error")
public class GlobalErrorController extends AbstractErrorController {

    public GlobalErrorController(ErrorAttributes errorAttributes) {
        super(errorAttributes);
    }

    @RequestMapping(produces = MediaType.ALL_VALUE)
    public String error(HttpServletRequest request) {
        HttpStatus status = getStatus(request);
        if (status.is5xxServerError()) {
            // log maybe
        }
        RequestContext ctx = RequestContext.getCurrentContext();
        // 响应异常数据
        return JsonMapper.toJsonString(Response.fail(ctx.get("error.status_code") + "", ctx.get("error.message") + ""));
    }

    public String getErrorPath() {
        return "/error";
    }


}
