package com.yizhi.application.filter;

import com.alibaba.fastjson.JSONObject;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.system.application.constant.SiteProtectConstants;
import com.yizhi.system.application.system.remote.SiteProtectClient;
import com.yizhi.util.application.constant.ReturnCode;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author: shengchenglong
 * @Description: 站点维护过滤器filter
 * @Modified By
 */
@Component
public class SiteProtectZuulFilter extends BaseZuulFilter {

    public static final String MOBILE_TAG = "#";// 移动端特殊路径

    private static Logger logger = LoggerFactory.getLogger(SiteProtectZuulFilter.class);

    @Autowired
    private SiteProtectClient siteProtectClient;

    @Autowired
    private RedisCache redisCache;

    @Override
    public boolean shouldFilter() {
        return true;
    }

    @Override
    public Object run() {
        HttpServletRequest request = RequestContext.getCurrentContext().getRequest();
        String companyCode = request.getParameter("companyCode");
        String siteCode = request.getParameter("siteCode");

        try {
            // 根据code查询关站信息
            if (StringUtils.isBlank(siteCode) || StringUtils.isBlank(companyCode)) {
                return null;
            }
            String message = (String) redisCache.hget(SiteProtectConstants.SITE_PROTECT_MESSAGE_PREF + companyCode, siteCode);
            if (StringUtils.isBlank(message)) {
                message = siteProtectClient.findProtectNoticeBySiteCode(siteCode, companyCode);
                if (StringUtils.isBlank(message)) {
                    return null;
                }
            }

            JSONObject object = new JSONObject();
            object.put("code", ReturnCode.SITE_PROTECT.getCode());
            object.put("msg", message);
            RequestContext.getCurrentContext().setResponseBody(JSONObject.toJSONString(object));
            return null;

        } catch (Exception e) {
            logger.error("异常信息--------:", e);
            logger.error("调用system查询关站信息失败--------siteCode:{}------companyCode:{}", siteCode, companyCode);
        }
        return null;
    }

}