package com.yizhi.log.application.remote;

import com.yizhi.log.application.vo.TaskLogVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;


/**
 * 日志服务远程调用接口
 * 注意:
 * 方法注解不要使用GetMapping,要使用RequestMapping
 * 如果是Get请求,方法参数要加上RequestParam,否则Feign组件会当作是Post请求
 *
 * @author scotthu
 * @date 2018年2月28日
 */

@FeignClient(name = "log", contextId = "RemoteTaskLogClient")
public interface RemoteTaskLogClient {

	@RequestMapping(value = "/remote/tasklog/getList", method = RequestMethod.GET)
	List<TaskLogVO> list();
}