package com.yizhi.log.application.remote;

import com.yizhi.util.application.page.PageInfo;
import com.yizhi.log.application.vo.TaskLogDetailVO;
import com.yizhi.log.application.vo.TaskLogVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;


/**
 * 日志服务远程调用接口
 * 注意:
 * 方法注解不要使用GetMapping,要使用RequestMapping
 * 如果是Get请求,方法参数要加上RequestParam,否则Feign组件会当作是Post请求
 *
 * @author scotthu
 * @date 2018年2月28日
 */

@FeignClient(value = "log", contextId = "TaskLogClient")
public interface TaskLogClient {

	@RequestMapping(value = "/remote/taskLog/list", method = RequestMethod.GET)
	public PageInfo<TaskLogVO> getTaskLogs(@RequestParam("pageInfo") PageInfo<TaskLogVO> pageInfo);

	@RequestMapping(value = "/remote/taskLog/submitter/list", method = RequestMethod.GET)
	public PageInfo<TaskLogVO> getTaskLogsBySubmitter(@RequestParam("submitterId") Long submitterId, @RequestParam("pageInfo") PageInfo<TaskLogVO> pageInfo);

	@RequestMapping(value = "/remote/taskLog/detail/list", method = RequestMethod.GET)
	public PageInfo<TaskLogDetailVO> getTaskLogDetails(@RequestParam("taskLogId") Long taskLogId, @RequestParam("pageInfo") PageInfo<TaskLogDetailVO> pageInfo);
}