package com.yizhi.application.handle;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import com.yizhi.core.application.log.TaskLogDetailEvent;
import com.yizhi.application.service.TaskLogDetailService;
import com.yizhi.util.application.constant.QueueConstant;

@Configuration
@RabbitListener(queues = QueueConstant.BATCH_TASK_LOG_DETAIL_QUEUE)
public class BatchTaskLogDetailListener {
	private static Logger log = LoggerFactory.getLogger(BatchTaskLogDetailListener.class);
	@Autowired
	TaskLogDetailService taskLogDetailService;

	@RabbitHandler
	public void saveLogDetail(List<TaskLogDetailEvent> details) {		
		try {
			taskLogDetailService.batchAddLogDetail(details);
		} catch (Exception e) {
			log.error("批量任务监控日志详情插入异常",e);
		}	
	}
}
