package com.yizhi.application.service.impl;

import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.log.TaskLogEvent;
import com.yizhi.application.domain.TaskLog;
import com.yizhi.application.mapper.TaskLogMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.application.service.TaskLogService;
import com.yizhi.util.application.date.DateUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;


@Service
public class TaskLogServiceImpl  extends ServiceImpl<TaskLogMapper, TaskLog> implements TaskLogService {
	
	@Autowired
	IdGenerator idGenerator;
	
	private static Logger log = LoggerFactory.getLogger(TaskLogServiceImpl.class);
	
	@Override
	public void add(TaskLogEvent taskLogEvent) {
		TaskLog  taskLog = this.selectById(taskLogEvent.getTaskId());
		if(taskLog == null) {
			taskLog = buildNewTaskLog(taskLogEvent);
			this.insert(taskLog);
			log.info("新增任务日志：{}",taskLogEvent);
		}else {
			taskLog = buildUpdateTaskLog(taskLogEvent);
			this.updateById(taskLog);
			log.info("更新任务日志：{}",taskLogEvent);
		}
		
		
	}

	/**
	 * 根据任务日志事件创建日志对象以备插入数据库
	 * @param taskLogEvent
	 * @return
	 */
	private TaskLog buildNewTaskLog(TaskLogEvent taskLogEvent) {
		TaskLog taskLog = new TaskLog();
		taskLog.setId(taskLogEvent.getTaskId());
		if(StringUtils.isNotEmpty(taskLogEvent.getTaskName())){
			taskLog.setName(taskLogEvent.getTaskName());
		}else{
			taskLog.setName("任务-未命名");
		}		
		taskLog.setSubmitterId(taskLogEvent.getSubmitterId());
		taskLog.setCreateById(taskLogEvent.getSubmitterId());
		taskLog.setSubmitTime(taskLogEvent.getSubmitTime());
		taskLog.setStatus(taskLogEvent.getStatus());
		taskLog.setResult(taskLogEvent.getResult());
		taskLog.setCreateTime(new Date());		
		taskLog.setSiteId(taskLogEvent.getSiteId());
		taskLog.setCompanyId(taskLogEvent.getCompanyId());
		if(StringUtils.isNotEmpty(taskLogEvent.getSerialNo())){
			taskLog.setSerialNo(taskLogEvent.getSerialNo());
		}else{
			taskLog.setSerialNo(DateUtil.getYMDHMSS());
		}
		if (StringUtils.isNotEmpty(taskLogEvent.getUrl())) {
			taskLog.setUrl(taskLogEvent.getUrl());
		}
		return taskLog;
	}
	
	/**
	 * 根据任务日志事件创建日志对象以备更新日志信息
	 * @param taskLogEvent 任务日志事件
	 * @return 任务日志
	 */
	private TaskLog buildUpdateTaskLog(TaskLogEvent taskLogEvent) {
		TaskLog taskLog = new TaskLog();
		taskLog.setId(taskLogEvent.getTaskId());
		taskLog.setStatus(taskLogEvent.getStatus());
		taskLog.setResult(taskLogEvent.getResult());
		taskLog.setUpdateTime(new Date());
		taskLog.setUrl(taskLogEvent.getUrl());
		return taskLog;
	}

	@Override
	public Page<TaskLog> list(TaskLog taskLog,Page<TaskLog> page) {
		//默认按创建时间排序
        page.setOrderByField("create_time");
        page.setAsc(false);
		String name=null;
		if(StringUtils.isNotEmpty(taskLog.getName())){
			name=taskLog.getName();
		}
		taskLog.setName(null);
		String serialNo=null;
		if(StringUtils.isNotEmpty(taskLog.getSerialNo())){
			serialNo=taskLog.getSerialNo();
		}
		taskLog.setSerialNo(null);
		Wrapper<TaskLog> wrapper=QueryUtil.condition(taskLog);
		if(null!=name){
			wrapper.like("name", name).or().like("serial_no", name);
		}
//		if(null!=serialNo){
//			wrapper.like("serial_no", serialNo);
//		}
		return this.selectPage(page, wrapper);
	}

	@Override
	public List<TaskLog> listByDate(TaskLog taskLog, Date startDate, Date endDate) {
		//默认按创建时间排序

//		log.info("分级授权开始 ------------------------------------------");
//		HQueryUtil.startHQ(TaskLog.class);

		Wrapper<TaskLog> wrapper = QueryUtil.condition(taskLog);

		if (null != startDate && null != endDate) {
			wrapper.lt("create_time", endDate).gt("create_time", startDate);
		}
		wrapper.eq("status",2);
		wrapper.eq("site_id", ContextHolder.get().getSiteId());
		wrapper.eq("submitter_id", ContextHolder.get().getAccountId());
		wrapper.orderBy("create_time", false);
		return this.selectList(wrapper);
	}
}
