package com.yizhi.application.orm.audit;

import java.sql.Timestamp;

import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AuditTestMetaObjectHandler extends AuditMetaObjectHandler {
	
   private static Logger log = LoggerFactory.getLogger(AuditTestMetaObjectHandler.class);
   
   @Override
   public void insertFill(MetaObject metaObject) {
    	
    	if(metaObject.hasGetter(CREATE_BY_FIELD)) {
    		metaObject.setValue(CREATE_BY_FIELD, 99999999L);
    		metaObject.setValue(CREATE_BY_NAME_FIELD, "testAccount");
    		metaObject.setValue(CREATE_BY_TIME_FIELD, new Timestamp(System.currentTimeMillis()));
    	}
    	
    	if(metaObject.hasGetter(UPDATE_BY_FIELD)) {
    		metaObject.setValue(UPDATE_BY_FIELD, 99999999L);
    		metaObject.setValue(UPDATE_BY_NAME_FIELD, "testAccount");
    		metaObject.setValue(UPDATE_BY_TIME_FIELD, new Timestamp(System.currentTimeMillis()));
    	}
    	    		
    }

    @Override
    public void updateFill(MetaObject metaObject) {
    	
    	if(metaObject.hasGetter(UPDATE_BY_FIELD)) {
    		metaObject.setValue(UPDATE_BY_FIELD, 99999999L);
    		metaObject.setValue(UPDATE_BY_NAME_FIELD, "testAccount");
    		metaObject.setValue(UPDATE_BY_TIME_FIELD, new Timestamp(System.currentTimeMillis()));
    	}
    }
}