package com.yizhi.application.orm.page;


import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.tuple.Pair;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import com.yizhi.util.application.page.PageInfo;
import com.yizhi.util.application.page.PageParam;

/**
 * 分页辅助类
 * @author scotthu
 *
 */
public class PageUtil {
	
	/**
	 * 分页参数转换到mybatis分页
	 * @param pageParam
	 * @return
	 */
	public static <T> Page<T> vice(PageParam<T> pageParam) {
		Page<T> page = new Page<T>();
		page.setCurrent(pageParam.getPageNo()==null ? 1:pageParam.getPageNo());
		page.setSize(pageParam.getPageSize()==null ||  pageParam.getPageSize() == 0 ? 10:pageParam.getPageSize());
		if(pageParam.getPageTotal() != null)
		   page.setTotal(pageParam.getPageTotal());
		if(StringUtils.isNotEmpty(pageParam.getPageSortField()))
		   page.setOrderByField(pageParam.getPageSortField());
        page.setAsc((null == pageParam.getPageSortType() || "desc".equals(pageParam.getPageSortType())) ? false : true);
        
        return page;
	}
	
	/**
	 * 框架分页转换到mybatis分页
	 * @param pageInfo
	 * @return
	 */
	public static <T> Page<T> vice(PageInfo<T> pageInfo) {
		Page<T> page = new Page<T>();
		page.setCurrent(pageInfo.getPageNo()==null ? 1:pageInfo.getPageNo());
		page.setSize(pageInfo.getPageSize()==null || pageInfo.getPageSize()==0 ? 10:pageInfo.getPageSize());
		if(pageInfo.getPageTotal() != null)
		   page.setTotal(pageInfo.getPageTotal());
		if(StringUtils.isNotEmpty(pageInfo.getPageSortField()))
		   page.setOrderByField(pageInfo.getPageSortField());
        page.setAsc((null == pageInfo.getPageSortType() || "desc".equals(pageInfo.getPageSortType())) ? false : true);
        
        return page;
	}

	/**
	 * mybatis分页转换到框架分页
	 * @param page
	 * @return
	 */
	public static <T> PageInfo<T> versa(Page<T> page) {
		PageInfo<T> pageInfo = new PageInfo<T>();
		pageInfo.setPageNo(page.getCurrent());
		pageInfo.setPageSize(page.getSize());
		pageInfo.setPageTotal(page.getPages());
		pageInfo.setPageRecords(page.getTotal());
		pageInfo.setRecords(page.getRecords());
		
		return pageInfo;
	}
	
	/**
	 * 分页信息和数据分离
	 * @param page
	 * @return
	 */
	public static <T> Pair<List<T>,Map<String,Integer>>  split(Page<T> page) {
		List<T> records = page.getRecords();
		
		Map<String,Integer> pageMap = new HashMap<>();
		pageMap.put("pageNo", page.getCurrent());
		pageMap.put("pageSize", page.getSize());
		pageMap.put("pageTotal", page.getPages());
		pageMap.put("pageRecords", page.getTotal());
		
		return Pair.of(records, pageMap);
	}
	
	/**
	 * 分页信息和数据分离
	 * @param page
	 * @return
	 */
	public static <T> Pair<List<T>,Map<String,Integer>>  convert(PageInfo<T> page) {
		List<T> records = page.getRecords();
		
		Map<String,Integer> pageMap = new HashMap<>();
		pageMap.put("pageNo", page.getPageNo());
		pageMap.put("pageSize", page.getPageSize());
		pageMap.put("pageTotal", page.getPageTotal());
		pageMap.put("pageRecords", page.getPageRecords());
		
		return Pair.of(records, pageMap);
	}
}
