package com.yizhi.application.orm.tenant;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.plugins.parser.AbstractJsqlParser;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;

import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.update.Update;

/**
 * 多租户sql处理
 * 
 * @author scotthu
 *
 */
public class TenantSqlParser extends AbstractJsqlParser {
	
	private static Logger log = LoggerFactory.getLogger(TenantSqlParser.class);

	@Override
	public void processSelectBody(SelectBody selectBody) {
//		if (selectBody instanceof PlainSelect) {
//			processPlainSelect((PlainSelect) selectBody);
//		} else if (selectBody instanceof WithItem) {
//			WithItem withItem = (WithItem) selectBody;
//			if (withItem.getSelectBody() != null) {
//				processSelectBody(withItem.getSelectBody());
//			}
//		} else {
//			SetOperationList operationList = (SetOperationList) selectBody;
//			if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
//				List<SelectBody> plainSelects = operationList.getSelects();
//				for (SelectBody plainSelect : plainSelects) {
//					processSelectBody(plainSelect);
//				}
//			}
//		}
	}

	/**
	 * 插入操作时多租户字段注入值
	 */
	@Override
	public void processInsert(Insert insert) {
		TenantType tenantType = TenantEntityHolder.getTenantType(insert.getTable().getName());
		if (tenantType == null)
			return;

//		List<Column> columns = insert.getColumns();
//		boolean companyExist = columnExist(columns, TenantInfo.COMPANY_COLUMN);
//		boolean siteExist = columnExist(columns, TenantInfo.SITE_COLUMN);
//		if (TenantType.COMPANY.equals(tenantType)) {
//			if (!companyExist)
//				columns.add(new Column(TenantInfo.COMPANY_COLUMN));
//		} else if (TenantType.SITE.equals(tenantType)) {
//			if (!companyExist)
//				columns.add(new Column(TenantInfo.COMPANY_COLUMN));
//			if (!siteExist)
//				columns.add(new Column(TenantInfo.SITE_COLUMN));
//		}
//
//		if (insert.getSelect() != null) {
//			processPlainSelect((PlainSelect) insert.getSelect().getSelectBody(), true);
//		} else if (insert.getItemsList() != null) {
//			List<Expression> expressions = ((ExpressionList) insert.getItemsList()).getExpressions();
//			if (TenantType.COMPANY.equals(tenantType) && !companyExist) {
//				expressions.add(new LongValue(ContextHolder.get().getCompanyId()));
//			} else if (TenantType.SITE.equals(tenantType) && !siteExist) {
//				expressions.add(new LongValue(ContextHolder.get().getCompanyId()));
//				expressions.add(new LongValue(ContextHolder.get().getSiteId()));
//			}
//
//		} else {
//			throw new MybatisPlusException(
//					"Failed to process multiple-table update, please exclude the tableName or statementId");
//		}
	}

	/**
	 * 判断字段列表中是否存在某字段
	 * @param columns  字段列表
	 * @param columnName  字段名称
	 * @return
	 */
	private boolean columnExist(List<Column> columns, String columnName) {
		for (Column column : columns) {
			if (column.getColumnName().equalsIgnoreCase(columnName))
				return true;
		}

		return false;
	}

	@Override
	public void processUpdate(Update update) {
		List<Table> tableList = update.getTables();
		if (null == tableList || tableList.size() >= 2) {
			throw new MybatisPlusException("Failed to process multiple-table update, please exclude the statementId");
		}

		Table table = tableList.get(0);
		TenantType tenantType = TenantEntityHolder.getTenantType(table.getName());
		if (tenantType == null)
			return;

//		update.setWhere(this.andExpression(table, update.getWhere(), tenantType));
	}

	@Override
	public void processDelete(Delete delete) {
		TenantType tenantType = TenantEntityHolder.getTenantType(delete.getTable().getName());
		if (tenantType == null)
			return;

//		delete.setWhere(this.andExpression(delete.getTable(), delete.getWhere(), tenantType));
	}

	protected BinaryExpression andExpression(Table table, Expression where, TenantType tenantType) {

		if (null == where) {
			return tenantExpression(table, tenantType, true,false,false);
		}

		String whereStr = where.toString();
		boolean companyExist = columnExistWithWhere(whereStr,TenantInfo.COMPANY_COLUMN);
		boolean siteExist = columnExistWithWhere(whereStr,TenantInfo.SITE_COLUMN);
		return new AndExpression(tenantExpression(table, tenantType, true,companyExist,siteExist), where);
	}

	/**
	 * where条件中加入多租户条件
	 * 如果多租户字段已存在则不添加
	 * @param table 表
	 * @param tenantType 租户类型
	 * @param withAlias  是否添加别名
	 * @param companyExist 企业是否已存在
	 * @param siteExist  站点是否已存在
	 * @return
	 */
	protected BinaryExpression tenantExpression(Table table, TenantType tenantType, boolean withAlias,boolean companyExist,boolean siteExist) {

		RequestContext ctx = ContextHolder.get();
		if (ctx == null) {
			return getConstantEqualsColumn();
		}

		if (TenantType.COMPANY.equals(tenantType)) {

			Long companyId = ctx.getCompanyId();
			if (companyId == null || companyExist) {
				return getConstantEqualsColumn();
			}

			EqualsTo equalsTo = new EqualsTo();
			equalsTo.setLeftExpression(this.getColumn(table, TenantInfo.COMPANY_COLUMN, withAlias));
			equalsTo.setRightExpression(new LongValue(companyId));
			return equalsTo;
		}

		EqualsTo equals1 = null;
		Long companyId = ctx.getCompanyId();
		if (companyId == null || companyExist) {
			equals1 = getConstantEqualsColumn();
		} else {
			equals1 = new EqualsTo();
			equals1.setLeftExpression(this.getColumn(table, TenantInfo.COMPANY_COLUMN, withAlias));
			equals1.setRightExpression(new LongValue(companyId));
		}

		EqualsTo equals2 = null;
		Long collegeId = ctx.getSiteId();
		if (collegeId == null || siteExist) {
			equals2 = getConstantEqualsColumn();
		} else {
			equals2 = new EqualsTo();
			equals2.setLeftExpression(this.getColumn(table, TenantInfo.SITE_COLUMN, withAlias));
			equals2.setRightExpression(new LongValue(collegeId));
		}
		return new AndExpression(equals1, equals2);
	}

	private EqualsTo getConstantEqualsColumn() {
		EqualsTo equalsTo = new EqualsTo();
		equalsTo.setLeftExpression(new Column("1"));
		equalsTo.setRightExpression(new LongValue("1"));
		return equalsTo;
	}

	protected void processPlainSelect(PlainSelect plainSelect) {
		processPlainSelect(plainSelect, false);
	}

	protected void processPlainSelect(PlainSelect plainSelect, boolean addColumn) {
		FromItem fromItem = plainSelect.getFromItem();
		if (fromItem instanceof Table) {
			Table fromTable = (Table) fromItem;
			TenantType tenantType = TenantEntityHolder.getTenantType(fromTable.getName());
			if (tenantType == null)
				return;

			boolean companyExist = false;
			boolean siteExist = false;
			Expression where = plainSelect.getWhere();
			if(where != null) {
				String whereStr = plainSelect.getWhere().toString();
				companyExist = columnExistWithWhere(whereStr,TenantInfo.COMPANY_COLUMN);
				siteExist = columnExistWithWhere(whereStr,TenantInfo.SITE_COLUMN);
			}
			plainSelect.setWhere(builderExpression(plainSelect.getWhere(), fromTable, tenantType,companyExist,siteExist));
		} else {
			processFromItem(fromItem);
		}

	}
	
	/**
	 * 判断where中是否存在多租户字段
	 * @param where  条件部分
	 * @param columnName  字段名
	 * @return
	 */
	private boolean columnExistWithWhere(String where,String columnName) {
		boolean leftMeet = false;
		boolean rightMeet = false;
		
		int startIndex = where.indexOf(columnName);
		if(startIndex < 0)
			return false;
		
		if(startIndex == 0) {
			leftMeet = true;
		}else {
			char a = where.charAt(startIndex - 1);
			if(a == '.' || a == ' ')
				leftMeet = true;
		}
		
		int endIndex = startIndex + columnName.length() - 1;
		if(endIndex == where.length() - 1) {
			rightMeet = true;
		}else {
			char a = where.charAt(endIndex + 1);
			if(a == ' ' || a == '=' || a == '>' || a == '<' || a == '!')
				rightMeet = true;
		}
		
		return leftMeet && rightMeet;
	}

	protected void processFromItem(FromItem fromItem) {
		if (fromItem instanceof SubSelect) {
			SubSelect subSelect = (SubSelect) fromItem;
			if (subSelect.getSelectBody() != null) {
				processSelectBody(subSelect.getSelectBody());
			}
		} else if (fromItem instanceof ValuesList) {
			logger.debug("Perform a subquery, if you do not give us feedback");
		} else if (fromItem instanceof LateralSubSelect) {
			LateralSubSelect lateralSubSelect = (LateralSubSelect) fromItem;
			if (lateralSubSelect.getSubSelect() != null) {
				SubSelect subSelect = lateralSubSelect.getSubSelect();
				if (subSelect.getSelectBody() != null) {
					processSelectBody(subSelect.getSelectBody());
				}
			}
		}
	}

	protected Expression builderExpression(Expression expression, Table table, TenantType tenantType,boolean companyExist,boolean siteExist) {
         
		if (expression == null) {
			return tenantExpression(table, tenantType, true, companyExist, siteExist);
		} else {
			if (expression instanceof BinaryExpression) {
				BinaryExpression binaryExpression = (BinaryExpression) expression;
				if (binaryExpression.getLeftExpression() instanceof FromItem) {
					processFromItem((FromItem) binaryExpression.getLeftExpression());
				}
				if (binaryExpression.getRightExpression() instanceof FromItem) {
					processFromItem((FromItem) binaryExpression.getRightExpression());
				}
			}
			return new AndExpression(tenantExpression(table, tenantType, true,companyExist, siteExist), expression);
		}
	}

	/**
	 * 生成要添加的字段
	 * @param table 表
	 * @param columnName  字段名
	 * @param withAlias 是否要添加表别名
	 * @return
	 */
	protected Column getColumn(Table table, String columnName, boolean withAlias) {
		if (!withAlias)
			return new Column(columnName);

		if (null == table.getAlias()) {
			return new Column(columnName);
		}
		StringBuilder column = new StringBuilder();
		column.append(table.getAlias().getName());
		column.append(".");
		column.append(columnName);
		return new Column(column.toString());
	}

}
