package com.yizhi.application.orm.id;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.junit.Assert;
import org.junit.Test;

import com.yizhi.util.application.date.DateUtil;


/**
 * Id生成器方法测试
 * @author scotthu
 *
 * @date 2018年3月9日
 */
public class IdGeneratorTest {
	
	/**
	 * 测试没有节点注册情况
	 */
	@Test
	public void testGenerateWithEmptyRegistry() {
		DistributeSnowFlakeIdGenerator  generator = new DistributeSnowFlakeIdGenerator();
		Map<Object, Object> registries = new HashMap<>();
		long id = generator.getCandidateWorkId(registries);
		Assert.assertTrue(id == 1);
	}
	
	/**
	 * 测试只有一个过期节点注册情况
	 */
	@Test
	public void testGenerateWithOneRegistry1() {
		DistributeSnowFlakeIdGenerator  generator = new DistributeSnowFlakeIdGenerator();
		Map<Object, Object> registries = new HashMap<>();
		registries.put("1", getOffsetDayTime(-1));
		long id = generator.getCandidateWorkId(registries);
		Assert.assertTrue(id == 2);
		
		registries.clear();
		registries.put("1023", getOffsetDayTime(-1));
		id = generator.getCandidateWorkId(registries);
		Assert.assertTrue(id == 1);
		
		registries.clear();
		registries.put("5", getOffsetDayTime(-1));
		registries.put("1023", getOffsetDayTime(-1));
		id = generator.getCandidateWorkId(registries);
		Assert.assertTrue(id == 4);
		
		registries.clear();
		registries.put("1", getOffsetDayTime(-1));
		registries.put("1022", getOffsetDayTime(-1));
		id = generator.getCandidateWorkId(registries);
		Assert.assertTrue(id == 1023);
		
		registries.clear();
		registries.put("1", getOffsetDayTime(-1));
		registries.put("2", getOffsetDayTime(-1));
		registries.put("3", getOffsetDayTime(-1));
		for (int i = 4; i <= 1023; i++) {
			registries.put("" + i, getOffsetDayTime(-3));
		}
		id = generator.getCandidateWorkId(registries);
		Assert.assertTrue(id == 4);
	}
	
	/**
	 * 测试死亡节点收集功能
	 */
	@Test
	public void testGetDeadIdGenerateNodes() {
		DistributeSnowFlakeIdGenerator  generator = new DistributeSnowFlakeIdGenerator();
		Map<Object, Object> registries = new HashMap<>();
		
		registries.clear();
		registries.put("1", getOffsetDayTime(-2));
		registries.put("2", getOffsetDayTime(0));
		registries.put("3", getOffsetDayTime(-3));

		Set<Object> deadNodes  = generator.getDeadIdGenerateNodes(registries);
		Assert.assertTrue(deadNodes.size() == 2);
	}
	
	private long getOffsetDayTime(int days) {
		return DateUtil.addDay(new Date(), days).getTime();
	}

    public static void main(String[] args) {
		Set<Long> ids = new HashSet<>();
		ids.add(1L);
		ids.add(100L);
		System.out.println(ids.toString());
	}
}
