package com.yizhi.system.application.exception;

import lombok.Data;

/**
 * 站点维护异常类
 */
@Data
public class SiteProtectBusinessException extends RuntimeException {

    private String errCode;
    private String msg;

    /**
     * Constructs a new runtime exception with {@code null} as its
     * detail message.  The cause is not initialized, and may subsequently be
     * initialized by a call to {@link #initCause}.
     */
    public SiteProtectBusinessException() {
    }


    /**
     * Constructs a new runtime exception with the specified detail message.
     * The cause is not initialized, and may subsequently be initialized by a
     * call to {@link #initCause}.
     *
     * @param message the detail message. The detail message is saved for
     *                later retrieval by the {@link #getMessage()} method.
     */
    public SiteProtectBusinessException(String errCode, String message) {
        super(message);
        this.errCode = errCode;
        this.msg = message;
    }


}
