package com.yizhi.system.application.feign;

import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

@FeignClient(value = "system", contextId = "InternationalizationWordClient")
public interface InternationalizationWordClient {

	@ApiOperation(value = "获取国际化翻译map", notes = "获取国际化翻译map")
	@GetMapping(value = "/manage/internationalizationWord/remote/getMap")
	public Map<Long, String> getMap(@RequestParam("tableType") String tableType,
                                    @RequestParam("taskIds") List<Long> taskIds,
									@RequestParam("languageType") String languageType);
}
