package com.yizhi.system.application.feign;

import com.yizhi.system.application.vo.SmsSendVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.Map;

@FeignClient(value = "system", contextId = "SmsSendRecordClient")
public interface SmsSendRecordClient {

    String SUCCESS_CODE = "code";

    /**
     * 简单短信发送接口，可以指定发送内容和短信模板id已经签名 ，如果自己指定发送内容，发送成功不返回验证码
     * @return
     */
    @PostMapping(value = "/api/smsSendRecord/simple/sms/send")
    Map<String,Object> simpleSmsSend(@RequestBody SmsSendVo smsSendVo);
}
