package com.yizhi.system.application.model;

import com.yizhi.core.application.context.RequestContext;
import lombok.Data;

/**
 * 可见范围导入参数
 *
 * @Author: shengchenglong
 * @Date: 2018/9/5 13:29
 */
@Data
public class AccountRangeImportParam {

    /**
     * 上传Excel的获取路径
     */
    private String ossUrl;

    /**
     * 服务类型，见内部枚举
     */
    private Type type;

    /**
     * 当前用户上下文
     */
    private RequestContext requestContext;

    private Long groupId;

    public enum Type {
        COURSE("course"),
        EXAM("exam"),
        RESEARCH("research"),
        LIVE("live"),
        VOTE("vote"),
        ASSIGNMENT("assignment"),
        CERTIFICATE("certificate"),
        ENROLL("enroll"),
        SIGN("sign"),
        SYSTEM("system"),
        MARKETINGCOURSE("marketingCourse"),
        CASELIBRARY("caseLibrary"),
        TRAININGPROJECT("trainingProject"),
        PRACTICE("practice");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

}
